<x-admin-layout>
    <x-slot name="pageTitle">Pengaturan Website</x-slot>
    <x-slot name="pageSubtitle">Atur logo, warna tema, informasi toko, dan kontak.</x-slot>

    <div class="space-y-6">
        {{-- Flash Messages --}}
        @if(session('status'))
            <div class="rounded-xl bg-emerald-50 dark:bg-emerald-900/30 border border-emerald-200 dark:border-emerald-800 p-4">
                <div class="flex items-center gap-3">
                    <span class="text-emerald-600 dark:text-emerald-400">✓</span>
                    <p class="text-sm font-medium text-emerald-700 dark:text-emerald-300">{{ session('status') }}</p>
                </div>
            </div>
        @endif
        @if(session('password_status'))
            <div class="rounded-xl bg-emerald-50 dark:bg-emerald-900/30 border border-emerald-200 dark:border-emerald-800 p-4">
                <div class="flex items-center gap-3">
                    <span class="text-emerald-600 dark:text-emerald-400">🔐</span>
                    <p class="text-sm font-medium text-emerald-700 dark:text-emerald-300">{{ session('password_status') }}</p>
                </div>
            </div>
        @endif

        {{-- Store Settings --}}
        <x-admin.card title="Identitas Brand">
            <form method="POST" action="{{ route('admin.settings.update') }}" class="mt-6 grid gap-5 md:grid-cols-2">
                @csrf
                @method('PATCH')
                <x-admin.input-field label="Nama Toko">
                    <input type="text" name="name" value="{{ old('name', $name) }}" required class="admin-input" />
                </x-admin.input-field>
                <x-admin.input-field label="Logo (URL / path)">
                    <input type="text" name="logo" value="{{ old('logo', $logo) }}" class="admin-input" />
                </x-admin.input-field>
                <x-admin.input-field label="Tagline">
                    <input type="text" name="tagline" value="{{ old('tagline', $tagline) }}" class="admin-input" />
                </x-admin.input-field>
                <x-admin.input-field label="Warna Brand">
                    <input type="text" name="brand_color" value="{{ old('brand_color', $brandColor) }}" class="admin-input" />
                </x-admin.input-field>
                <x-admin.input-field label="WhatsApp Admin">
                    <input type="text" name="whatsapp" value="{{ old('whatsapp', $whatsapp) }}" class="admin-input" />
                </x-admin.input-field>
                <div class="md:col-span-2 flex justify-end gap-2">
                    <button class="inline-flex items-center rounded-full bg-[#C26A3D] px-5 py-2 text-sm font-semibold text-white hover:bg-[#a85327]">Simpan</button>
                </div>
            </form>
        </x-admin.card>

        {{-- Password Settings --}}
        <x-admin.card title="Ubah Password Admin">
            <x-slot name="icon">
                <svg class="h-5 w-5 text-rose-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                </svg>
            </x-slot>
            <form method="POST" action="{{ route('admin.settings.password') }}" class="mt-6 space-y-5">
                @csrf
                @method('PATCH')
                
                <div class="max-w-md">
                    <x-admin.input-field label="Password Lama">
                        <div class="relative">
                            <input type="password" name="current_password" id="current_password" required 
                                class="admin-input pr-12 @error('current_password') !border-rose-500 @enderror" 
                                placeholder="Masukkan password lama" />
                            <button type="button" onclick="togglePassword('current_password', 'eyeIcon1')" 
                                class="absolute inset-y-0 right-0 flex items-center pr-4 text-slate-400 hover:text-slate-600 dark:hover:text-slate-300">
                                <svg id="eyeIcon1" class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                </svg>
                            </button>
                        </div>
                        @error('current_password')
                            <p class="mt-1 text-xs text-rose-600 dark:text-rose-400">{{ $message }}</p>
                        @enderror
                    </x-admin.input-field>
                </div>

                <div class="max-w-md">
                    <x-admin.input-field label="Password Baru">
                        <div class="relative">
                            <input type="password" name="password" id="new_password" required 
                                class="admin-input pr-12 @error('password') !border-rose-500 @enderror" 
                                placeholder="Minimal 8 karakter" />
                            <button type="button" onclick="togglePassword('new_password', 'eyeIcon2')" 
                                class="absolute inset-y-0 right-0 flex items-center pr-4 text-slate-400 hover:text-slate-600 dark:hover:text-slate-300">
                                <svg id="eyeIcon2" class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                </svg>
                            </button>
                        </div>
                        @error('password')
                            <p class="mt-1 text-xs text-rose-600 dark:text-rose-400">{{ $message }}</p>
                        @enderror
                    </x-admin.input-field>
                </div>

                <div class="max-w-md">
                    <x-admin.input-field label="Konfirmasi Password Baru">
                        <div class="relative">
                            <input type="password" name="password_confirmation" id="confirm_password" required 
                                class="admin-input pr-12" 
                                placeholder="Ulangi password baru" />
                            <button type="button" onclick="togglePassword('confirm_password', 'eyeIcon3')" 
                                class="absolute inset-y-0 right-0 flex items-center pr-4 text-slate-400 hover:text-slate-600 dark:hover:text-slate-300">
                                <svg id="eyeIcon3" class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                </svg>
                            </button>
                        </div>
                    </x-admin.input-field>
                </div>

                <div class="flex items-center gap-4 pt-2">
                    <button type="submit" class="inline-flex items-center gap-2 rounded-full bg-rose-600 px-5 py-2.5 text-sm font-semibold text-white hover:bg-rose-700 transition shadow-md">
                        <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z"/>
                        </svg>
                        Ubah Password
                    </button>
                    <p class="text-xs text-slate-500 dark:text-slate-400">
                        Pastikan Anda mengingat password baru Anda.
                    </p>
                </div>
            </form>
        </x-admin.card>
    </div>

    @push('scripts')
    <script>
        function togglePassword(inputId, iconId) {
            const input = document.getElementById(inputId);
            const icon = document.getElementById(iconId);
            
            if (input.type === 'password') {
                input.type = 'text';
                icon.innerHTML = `
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"/>
                `;
            } else {
                input.type = 'password';
                icon.innerHTML = `
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                `;
            }
        }
    </script>
    @endpush
</x-admin-layout>
