<x-admin-layout>
    <x-slot name="pageTitle">Edit Produk</x-slot>
    <x-slot name="pageSubtitle">Perbarui informasi produk dan kelola galeri foto.</x-slot>

    <form method="POST" action="{{ route('admin.products.update', $product) }}" enctype="multipart/form-data" class="space-y-8">
        @csrf
        @method('PUT')

        <x-admin.card title="Informasi Produk">
            <div class="mt-6 space-y-5">
                <div class="grid gap-5 md:grid-cols-2">
                    <div>
                        <label class="text-xs font-semibold text-slate-600">Kategori</label>
                        <select name="category_id" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                            @foreach ($categories as $category)
                                <option value="{{ $category->id }}" @selected(old('category_id', $product->category_id) == $category->id)>{{ $category->name }}</option>
                            @endforeach
                        </select>
                        @error('category_id') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label class="text-xs font-semibold text-slate-600">SKU</label>
                        <input type="text" name="sku" value="{{ old('sku', $product->sku) }}" required class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                        @error('sku') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                    </div>
                </div>

                <div>
                    <label class="text-xs font-semibold text-slate-600">Nama Produk</label>
                    <input type="text" name="name" value="{{ old('name', $product->name) }}" required class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                    @error('name') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                </div>

                <div class="grid gap-5 md:grid-cols-2">
                    <div>
                        <label class="text-xs font-semibold text-slate-600">Tagline</label>
                        <input type="text" name="tagline" value="{{ old('tagline', $product->tagline) }}" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                    </div>
                    <div>
                        <label class="text-xs font-semibold text-slate-600">Ringkasan</label>
                        <input type="text" name="summary" value="{{ old('summary', $product->summary) }}" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                    </div>
                </div>

                <div>
                    <label class="text-xs font-semibold text-slate-600">Deskripsi Lengkap</label>
                    <textarea name="description" rows="4" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">{{ old('description', $product->description) }}</textarea>
                    @error('description') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                </div>
            </div>
        </x-admin.card>

        <x-admin.card title="Harga & Stok">
            <div class="mt-6 grid gap-5 sm:grid-cols-3">
                <div>
                    <label class="text-xs font-semibold text-slate-600">Harga</label>
                    <input type="number" name="price" value="{{ old('price', $product->price) }}" min="0" required class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                    @error('price') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                </div>
                <div>
                    <label class="text-xs font-semibold text-slate-600">Stok</label>
                    <input type="number" name="stock" value="{{ old('stock', $product->stock) }}" min="0" required class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                    @error('stock') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                </div>
                <div>
                    <label class="text-xs font-semibold text-slate-600">Diskon (%)</label>
                    <input type="number" name="discount_percent" value="{{ old('discount_percent', $product->discount_percent) }}" min="0" max="90" step="0.1" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                    @error('discount_percent') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                </div>
                <div>
                    <label class="text-xs font-semibold text-slate-600">Min Order</label>
                    <input type="number" name="min_order_qty" value="{{ old('min_order_qty', $product->min_order_qty) }}" min="1" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                    @error('min_order_qty') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                </div>
                <div>
                    <label class="text-xs font-semibold text-slate-600">Max Order</label>
                    <input type="number" name="max_order_qty" value="{{ old('max_order_qty', $product->max_order_qty) }}" min="1" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                    @error('max_order_qty') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                </div>
                <div>
                    <label class="text-xs font-semibold text-slate-600">Berat (gram)</label>
                    <input type="number" name="weight_grams" value="{{ old('weight_grams', $product->weight_grams) }}" min="0" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                    @error('weight_grams') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                </div>
            </div>
            <div class="mt-6 flex flex-wrap items-center gap-3 text-sm">
                <label class="text-xs font-semibold text-slate-600">Produk Unggulan</label>
                <input type="checkbox" name="is_featured" value="1" @checked(old('is_featured', $product->is_featured)) class="h-4 w-4 rounded border-[#FAD4C2] text-[#C26A3D] focus:ring-[#C26A3D]">
                <select name="status" class="rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                    <option value="active" @selected(old('status', $product->status) === 'active')>Aktif</option>
                    <option value="draft" @selected(old('status', $product->status) === 'draft')>Draft</option>
                    <option value="archived" @selected(old('status', $product->status) === 'archived')>Arsip</option>
                </select>
                @error('status') <p class="text-xs text-rose-500">{{ $message }}</p> @enderror
            </div>
        </x-admin.card>

        <x-admin.card title="Media Produk">
            <div class="mt-6 space-y-5 text-sm text-slate-600">
                <div class="grid gap-5 md:grid-cols-2">
                    <div>
                        <label class="text-xs font-semibold text-slate-600">Thumbnail Utama</label>
                        <input type="file" name="thumbnail" class="mt-2 block w-full text-sm text-slate-600" accept="image/*">
                        @error('thumbnail') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                        @if ($product->thumbnail_url)
                            <div class="mt-3 space-y-2">
                                <img src="{{ $product->thumbnail_url }}" alt="Thumbnail" class="h-28 w-28 rounded-2xl object-cover">
                                <p class="text-xs text-slate-500 font-mono break-all">{{ $product->getRawOriginal('thumbnail') ?? '-' }}</p>
                                <label class="flex items-center gap-2 cursor-pointer hover:bg-white/50 p-2 rounded-lg transition w-fit">
                                    <input type="checkbox" name="remove_thumbnail" value="1" class="h-4 w-4 rounded border-2 border-[#FAD4C2] bg-white text-[#C26A3D] focus:ring-[#C26A3D] focus:ring-2 checked:bg-[#C26A3D] checked:border-[#C26A3D]">
                                    <span class="text-xs text-slate-600 select-none">Hapus thumbnail ini</span>
                                </label>
                            </div>
                        @endif
                    </div>
                    <div>
                        <label class="text-xs font-semibold text-slate-600">Tambah Foto Galeri</label>
                        <input type="file" name="gallery[]" multiple class="mt-2 block w-full text-sm text-slate-600" accept="image/*">
                        <p class="mt-1 text-[11px] text-slate-400">Foto baru akan ditambahkan ke galeri.</p>
                        @error('gallery.*') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                    </div>
                </div>

                @if ($product->images->isNotEmpty())
                    <div class="grid gap-4 sm:grid-cols-3">
                        @foreach ($product->images as $image)
                            <div class="relative rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] p-3 text-xs text-slate-600">
                                <img src="{{ $image->path }}" alt="{{ $product->name }}" class="h-28 w-full rounded-xl object-cover">
                                <span class="absolute top-3 left-3 inline-flex items-center rounded bg-white/90 px-2 py-1 text-[10px] font-semibold text-slate-600">{{ $image->is_primary ? 'Utama' : 'Galeri' }}</span>
                                <p class="mt-2 text-xs text-slate-500 font-mono break-all">{{ $image->getRawOriginal('path') ?? '-' }}</p>
                                <span class="mt-1 block text-xs text-slate-400">{{ $image->alt_text ?? 'Foto tambahan' }}</span>
                                <label class="mt-2 flex items-center gap-2 cursor-pointer hover:bg-white/50 p-2 rounded-lg transition">
                                    <input type="checkbox" name="remove_images[]" value="{{ $image->id }}" class="h-4 w-4 rounded border-2 border-[#FAD4C2] bg-white text-[#C26A3D] focus:ring-[#C26A3D] focus:ring-2 checked:bg-[#C26A3D] checked:border-[#C26A3D]">
                                    <span class="text-xs text-slate-600 select-none">Hapus foto ini</span>
                                </label>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>
        </x-admin.card>

        <div class="flex justify-end gap-3">
            <a href="{{ route('admin.products.index') }}" class="inline-flex items-center rounded-full border border-slate-300 px-6 py-3 text-sm font-semibold text-slate-600 transition hover:bg-slate-100">Batal</a>
            <button type="submit" class="inline-flex items-center rounded-full bg-[#C26A3D] px-6 py-3 text-sm font-semibold text-white transition hover:bg-[#a85327]">Simpan Perubahan</button>
        </div>
    </form>
</x-admin-layout>
