<x-admin-layout>
    <x-slot name="pageTitle">Tambah Produk Baru</x-slot>
    <x-slot name="pageSubtitle">Lengkapi informasi produk untuk tampil profesional di katalog.</x-slot>

    <form method="POST" action="{{ route('admin.products.store') }}" enctype="multipart/form-data" class="space-y-8">
        @csrf

        <div class="grid gap-3 sm:grid-cols-3">
            <div class="rounded-2xl border border-[#FAD4C2]/70 bg-white/60 px-4 py-3 text-xs text-slate-600 shadow-sm">
                <p class="text-[11px] font-semibold text-[#C26A3D]">Langkah 1</p>
                <p class="font-semibold text-slate-800">Informasi Produk</p>
                <p class="text-[11px] text-slate-500">Nama, kategori, deskripsi singkat.</p>
            </div>
            <div class="rounded-2xl border border-[#FAD4C2]/70 bg-white/60 px-4 py-3 text-xs text-slate-600 shadow-sm">
                <p class="text-[11px] font-semibold text-[#C26A3D]">Langkah 2</p>
                <p class="font-semibold text-slate-800">Harga & Stok</p>
                <p class="text-[11px] text-slate-500">Harga, stok, batas order.</p>
            </div>
            <div class="rounded-2xl border border-[#FAD4C2]/70 bg-white/60 px-4 py-3 text-xs text-slate-600 shadow-sm">
                <p class="text-[11px] font-semibold text-[#C26A3D]">Langkah 3</p>
                <p class="font-semibold text-slate-800">Media & Status</p>
                <p class="text-[11px] text-slate-500">Thumbnail, galeri, visibilitas.</p>
            </div>
        </div>

        <div class="grid gap-6 lg:grid-cols-[1.6fr,1fr]">
            <div class="space-y-6">
                <x-admin.card title="Informasi Produk" subtitle="Detail utama yang ditampilkan ke pelanggan.">
                    <div class="mt-6 space-y-5">
                        <div class="grid gap-5 md:grid-cols-2">
                            <div>
                                <div class="flex items-center justify-between text-xs font-semibold text-slate-600">
                                    <label>Kategori</label>
                                    <span class="rounded-full bg-[#FFE2CF] px-2 py-0.5 text-[10px] text-[#C26A3D]">Wajib</span>
                                </div>
                                <select name="category_id" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->id }}" @selected(old('category_id') == $category->id)>{{ $category->name }}</option>
                                    @endforeach
                                </select>
                                @error('category_id') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <div class="flex items-center justify-between text-xs font-semibold text-slate-600">
                                    <label>SKU</label>
                                    <span class="text-[10px] text-slate-400">Unik</span>
                                </div>
                                <input type="text" name="sku" value="{{ old('sku') }}" required placeholder="SKU unik, mis. DS-001" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                                @error('sku') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                            </div>
                        </div>

                        <div>
                            <label class="text-xs font-semibold text-slate-600">Nama Produk</label>
                            <input type="text" name="name" value="{{ old('name') }}" required placeholder="Cth: Serum Wajah Brightening 30ml" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                            @error('name') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                        </div>

                        <div class="grid gap-5 md:grid-cols-2">
                            <div>
                                <label class="text-xs font-semibold text-slate-600">Tagline</label>
                                <input type="text" name="tagline" value="{{ old('tagline') }}" placeholder="Sorot benefit utama" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                            </div>
                            <div>
                                <label class="text-xs font-semibold text-slate-600">Ringkasan</label>
                                <input type="text" name="summary" value="{{ old('summary') }}" placeholder="Kalimat singkat untuk kartu produk" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                            </div>
                        </div>

                        <div>
                            <div class="flex items-center justify-between">
                                <label class="text-xs font-semibold text-slate-600">Deskripsi Lengkap</label>
                                <span class="text-[10px] text-slate-400">Boleh kosong</span>
                            </div>
                            <textarea name="description" rows="4" placeholder="Ceritakan detail produk, bahan, cara pakai, atau garansi." class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">{{ old('description') }}</textarea>
                            @error('description') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                        </div>
                    </div>
                </x-admin.card>

                <x-admin.card title="Harga & Stok">
                    <div class="mt-6 grid gap-5 sm:grid-cols-3">
                        <div>
                            <label class="text-xs font-semibold text-slate-600">Harga</label>
                            <input type="number" name="price" value="{{ old('price') }}" min="0" required placeholder="0" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                            @error('price') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                        </div>
                        <div>
                            <label class="text-xs font-semibold text-slate-600">Stok</label>
                            <input type="number" name="stock" value="{{ old('stock', 0) }}" min="0" required placeholder="0" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                            @error('stock') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                        </div>
                        <div>
                            <label class="text-xs font-semibold text-slate-600">Diskon (%)</label>
                            <input type="number" name="discount_percent" value="{{ old('discount_percent', 0) }}" min="0" max="90" step="0.1" placeholder="0" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                            @error('discount_percent') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                        </div>
                        <div>
                            <label class="text-xs font-semibold text-slate-600">Min Order</label>
                            <input type="number" name="min_order_qty" value="{{ old('min_order_qty', 1) }}" min="1" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                            @error('min_order_qty') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                        </div>
                        <div>
                            <label class="text-xs font-semibold text-slate-600">Max Order</label>
                            <input type="number" name="max_order_qty" value="{{ old('max_order_qty') }}" min="1" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                            @error('max_order_qty') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                        </div>
                        <div>
                            <label class="text-xs font-semibold text-slate-600">Berat (gram)</label>
                            <input type="number" name="weight_grams" value="{{ old('weight_grams') }}" min="0" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                            @error('weight_grams') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                        </div>
                    </div>
                </x-admin.card>
            </div>

            <div class="space-y-6">
                <x-admin.card title="Status & Visibilitas" subtitle="Atur tampil/draft serta tandai unggulan.">
                    <div class="mt-5 space-y-4 text-sm text-slate-600">
                        <div class="flex items-center justify-between rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-3">
                            <div>
                                <p class="text-xs font-semibold text-slate-700">Produk Unggulan</p>
                                <p class="text-[11px] text-slate-500">Tampilkan di banner/section khusus.</p>
                            </div>
                            <input type="checkbox" name="is_featured" value="1" @checked(old('is_featured')) class="h-4 w-4 rounded border-[#FAD4C2] text-[#C26A3D] focus:ring-[#C26A3D]">
                        </div>
                        <div>
                            <label class="text-xs font-semibold text-slate-700">Status Tayang</label>
                            <select name="status" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">
                                <option value="active" @selected(old('status', 'active') === 'active')>Aktif</option>
                                <option value="draft" @selected(old('status') === 'draft')>Draft</option>
                                <option value="archived" @selected(old('status') === 'archived')>Arsip</option>
                            </select>
                            @error('status') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                        </div>
                        <div class="rounded-2xl border border-slate-200 bg-white px-4 py-3 text-[12px] text-slate-500">
                            <p class="font-semibold text-slate-700">Catatan cepat</p>
                            <ul class="mt-2 space-y-1">
                                <li>• SKU unik mencegah duplikat pesanan.</li>
                                <li>• Draft untuk simpan tanpa tayang.</li>
                                <li>• Tandai unggulan untuk promo depan.</li>
                            </ul>
                        </div>
                    </div>
                </x-admin.card>

                <x-admin.card title="Media Produk" subtitle="Thumbnail utama dan galeri akan muncul pada halaman katalog.">
                    <div class="mt-6 space-y-5 text-sm text-slate-600">
                        <div class="rounded-2xl border border-dashed border-[#FAD4C2] bg-[#FFF8F3] px-4 py-5">
                            <label class="text-xs font-semibold text-slate-600">Thumbnail Utama</label>
                            <input type="file" name="thumbnail" class="mt-2 block w-full text-sm text-slate-600" accept="image/*">
                            <p class="mt-1 text-[11px] text-slate-500">Gunakan rasio 1:1 agar tampil rapi.</p>
                            @error('thumbnail') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                        </div>
                        <div class="rounded-2xl border border-dashed border-[#FAD4C2] bg-[#FFF8F3] px-4 py-5">
                            <label class="text-xs font-semibold text-slate-600">Galeri Produk</label>
                            <input type="file" name="gallery[]" multiple class="mt-2 block w-full text-sm text-slate-600" accept="image/*">
                            <p class="mt-1 text-[11px] text-slate-500">Upload beberapa foto sudut berbeda.</p>
                            @error('gallery.*') <p class="mt-1 text-xs text-rose-500">{{ $message }}</p> @enderror
                        </div>
                    </div>
                </x-admin.card>
            </div>
        </div>

        <div class="sticky bottom-0 z-10 flex flex-col gap-3 border-t border-[#FAD4C2]/70 bg-white/90 px-4 py-3 sm:flex-row sm:items-center sm:justify-between sm:px-6">
            <div class="text-xs text-slate-500">
                Pastikan harga, stok, dan status sudah benar sebelum simpan.
            </div>
            <div class="flex items-center gap-3">
                <a href="{{ route('admin.products.index') }}" class="inline-flex items-center rounded-full border border-slate-300 px-5 py-2 text-sm font-semibold text-slate-600 transition hover:bg-slate-50">Batal</a>
                <button type="submit" class="inline-flex items-center rounded-full bg-[#C26A3D] px-6 py-2.5 text-sm font-semibold text-white transition hover:bg-[#a85327]">
                    Simpan Produk
                </button>
            </div>
        </div>
    </form>
</x-admin-layout>
