<x-admin-layout>
    <x-slot name="pageTitle">Riwayat Pembayaran</x-slot>
    <x-slot name="pageSubtitle">Pantau pembayaran Midtrans, transfer manual, dan COD.</x-slot>

    <x-admin.card title="Filter Pembayaran">
        <form method="GET" class="mt-4 grid gap-4 lg:grid-cols-[2fr,1fr,1fr]">
            <x-admin.input-field label="Cari Referensi/VA">
                <input type="text" name="search" value="{{ $filters['search'] }}" class="admin-input" placeholder="Ref/VA" />
            </x-admin.input-field>
            <x-admin.input-field label="Metode">
                <select name="method" class="admin-input">
                    <option value="">Semua</option>
                    <option value="midtrans" @selected($filters['method']==='midtrans')>Midtrans</option>
                    <option value="manual_transfer" @selected($filters['method']==='manual_transfer')>Transfer</option>
                    <option value="cash" @selected($filters['method']==='cash')>Tunai / COD</option>
                </select>
            </x-admin.input-field>
            <x-admin.input-field label="Status">
                <select name="status" class="admin-input">
                    <option value="">Semua</option>
                    <option value="pending" @selected($filters['status']==='pending')>Pending</option>
                    <option value="paid" @selected($filters['status']==='paid')>Berhasil</option>
                    <option value="failed" @selected($filters['status']==='failed')>Gagal</option>
                </select>
            </x-admin.input-field>
            <div class="lg:col-span-3 flex justify-end gap-2">
                <a href="{{ route('admin.payments.index') }}" class="inline-flex items-center rounded-full border px-4 py-2 text-sm">Reset</a>
                <button class="inline-flex items-center rounded-full bg-[#C26A3D] px-5 py-2 text-sm font-semibold text-white hover:bg-[#a85327]">Terapkan</button>
            </div>
        </form>
    </x-admin.card>

    <x-admin.card title="Daftar Pembayaran">
        <div class="mt-4 overflow-hidden rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-[#FAD4C2]/60 dark:divide-slate-800 text-sm">
                    <thead class="bg-[#FFF0E6] dark:bg-slate-800 text-left text-xs uppercase text-slate-500 dark:text-slate-400">
                        <tr>
                            <th class="px-4 py-3">Order</th>
                            <th class="px-4 py-3">Metode</th>
                            <th class="px-4 py-3">Status</th>
                            <th class="px-4 py-3 text-right">Nominal</th>
                            <th class="px-4 py-3">Referensi</th>
                            <th class="px-4 py-3">Dibayar</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-[#FAD4C2]/40 dark:divide-slate-800 bg-white dark:bg-slate-900">
                        @forelse ($payments as $p)
                            <tr class="transition hover:bg-[#FFF7F2] dark:hover:bg-slate-800">
                                <td class="px-4 py-4 font-semibold text-slate-800 dark:text-slate-100">{{ $p->order?->invoice_number ?? '#' . $p->order_id }}</td>
                                <td class="px-4 py-4">{{ strtoupper(str_replace('_',' ', $p->method)) }}</td>
                                <td class="px-4 py-4">
                                    <span class="inline-flex items-center rounded-full px-3 py-1 text-[11px] font-semibold {{ $p->status === 'paid' ? 'bg-emerald-100 text-emerald-700' : ($p->status === 'failed' ? 'bg-rose-100 text-rose-700' : 'bg-amber-100 text-amber-700') }}">{{ strtoupper($p->status) }}</span>
                                </td>
                                <td class="px-4 py-4 text-right font-semibold text-[#C26A3D]">Rp{{ number_format($p->amount, 0, ',', '.') }}</td>
                                <td class="px-4 py-4 text-xs">{{ $p->reference ?: $p->virtual_account ?: '-' }}</td>
                                <td class="px-4 py-4">{{ $p->paid_at?->format('d M Y H:i') ?: '-' }}</td>
                            </tr>
                        @empty
                            <tr><td colspan="6" class="px-4 py-8 text-center text-slate-500">Belum ada data pembayaran.</td></tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        <div class="mt-4">{{ $payments->onEachSide(1)->links() }}</div>
    </x-admin.card>
</x-admin-layout>

