<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <title>Struk {{ $order->invoice_number }}</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { 
            font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif; 
            background: #f3f4f6;
            padding: 20px;
            color: #1f2937;
        }
        .receipt { 
            max-width: 800px; 
            margin: 0 auto; 
            background: #fff; 
            border: 1px solid #e5e7eb;
            border-radius: 8px; 
            padding: 40px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        .header {
            border-bottom: 2px solid #3b82f6;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        h1 { 
            font-size: 24px; 
            color: #1f2937;
            margin-bottom: 5px;
        }
        .invoice-no {
            font-size: 14px;
            color: #6b7280;
            font-weight: 500;
        }
        .badge { 
            display: inline-block;
            padding: 4px 12px;
            border-radius: 999px;
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin: 8px 8px 0 0;
        }
        .badge-primary { background: #dbeafe; color: #1e40af; }
        .badge-success { background: #d1fae5; color: #065f46; }
        .badge-warning { background: #fef3c7; color: #92400e; }
        
        .info-section {
            margin-bottom: 30px;
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
        }
        .info-box {
            background: #f9fafb;
            padding: 15px;
            border-radius: 6px;
            border-left: 3px solid #3b82f6;
        }
        .info-label {
            font-size: 11px;
            color: #6b7280;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-weight: 600;
            margin-bottom: 4px;
        }
        .info-value {
            font-size: 14px;
            color: #1f2937;
            font-weight: 500;
        }
        
        table { 
            width: 100%; 
            border-collapse: collapse; 
            margin-bottom: 20px;
        }
        thead {
            background: #f3f4f6;
        }
        th { 
            padding: 12px 8px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: #4b5563;
            text-align: left;
        }
        td { 
            padding: 12px 8px;
            font-size: 14px;
            border-bottom: 1px solid #f3f4f6;
        }
        tbody tr:last-child td {
            border-bottom: none;
        }
        .text-right { text-align: right; }
        
        .totals {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 2px solid #e5e7eb;
        }
        .totals-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            font-size: 14px;
        }
        .totals-row.grand-total {
            font-size: 18px;
            font-weight: 700;
            color: #1f2937;
            padding: 15px;
            background: #f3f4f6;
            border-radius: 6px;
            margin-top: 10px;
        }
        
        .footer { 
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #e5e7eb;
            text-align: center;
            font-size: 12px;
            color: #6b7280;
        }
        .print-btn {
            position: fixed;
            top: 20px;
            right: 20px;
            padding: 10px 20px;
            background: #3b82f6;
            color: #fff;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-weight: 600;
            font-size: 14px;
            box-shadow: 0 2px 4px rgba(59, 130, 246, 0.3);
        }
        .print-btn:hover {
            background: #2563eb;
        }
        
        @media print {
            body { 
                background: #fff;
                padding: 0;
            }
            .receipt { 
                border-radius: 0;
                border: none;
                box-shadow: none;
            }
            .print-btn {
                display: none;
            }
        }
    </style>
</head>
<body>
    <button class="print-btn" onclick="window.print()">🖨️ Cetak</button>
    
    <div class="receipt">
        <div class="header">
            <h1>{{ $storeName }}</h1>
            <p class="invoice-no">Invoice: {{ $order->invoice_number }}</p>
            <p class="invoice-no">Tanggal: {{ $order->created_at->translatedFormat('d F Y, H:i') }} WIB</p>
            <div style="margin-top: 10px;">
                <span class="badge badge-primary">{{ strtoupper($order->status) }}</span>
                <span class="badge {{ $order->payment_status === 'paid' ? 'badge-success' : 'badge-warning' }}">
                    {{ strtoupper($order->payment_status) }}
                </span>
            </div>
        </div>

        <div class="info-section">
            <div class="info-box">
                <div class="info-label">Pelanggan</div>
                <div class="info-value">
                    @if($order->channel === 'online' && $order->user)
                        {{ $order->user->name }}
                    @elseif($order->channel === 'offline')
                        {{ $order->metadata['customer_name'] ?? 'Pelanggan Umum' }}
                    @else
                        -
                    @endif
                </div>
            </div>
            
            <div class="info-box">
                <div class="info-label">Kanal Penjualan</div>
                <div class="info-value">{{ $order->channel === 'online' ? 'Online Store' : 'POS Kasir' }}</div>
            </div>
            
            @if($order->channel === 'offline' && $order->cashier)
            <div class="info-box">
                <div class="info-label">Kasir</div>
                <div class="info-value">{{ $order->cashier->name }}</div>
            </div>
            @endif
            
            @if($order->payment_method)
            <div class="info-box">
                <div class="info-label">Metode Pembayaran</div>
                <div class="info-value">{{ strtoupper($order->payment_method) }}</div>
            </div>
            @endif
        </div>

        <table>
            <thead>
                <tr>
                    <th>Produk</th>
                    <th class="text-right">Qty</th>
                    <th class="text-right">Harga</th>
                    <th class="text-right">Subtotal</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($order->items as $item)
                    <tr>
                        <td>{{ $item->product_name }}</td>
                        <td class="text-right">{{ $item->quantity }}</td>
                        <td class="text-right">Rp{{ number_format($item->unit_price, 0, ',', '.') }}</td>
                        <td class="text-right">Rp{{ number_format($item->subtotal, 0, ',', '.') }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        <div class="totals">
            <div class="totals-row">
                <span>Subtotal</span>
                <span>Rp{{ number_format($order->subtotal_amount, 0, ',', '.') }}</span>
            </div>
            @if($order->discount_amount > 0)
            <div class="totals-row">
                <span>Diskon</span>
                <span>- Rp{{ number_format($order->discount_amount, 0, ',', '.') }}</span>
            </div>
            @endif
            @if($order->shipping_cost > 0)
            <div class="totals-row">
                <span>Ongkos Kirim</span>
                <span>Rp{{ number_format($order->shipping_cost, 0, ',', '.') }}</span>
            </div>
            @endif
            <div class="totals-row grand-total">
                <span>TOTAL</span>
                <span>Rp{{ number_format($order->grand_total, 0, ',', '.') }}</span>
            </div>
        </div>

        @if($order->shipping_address)
        <div class="info-section" style="margin-top: 30px;">
            <div class="info-box" style="grid-column: span 2;">
                <div class="info-label">Alamat Pengiriman</div>
                <div class="info-value">
                    {{ $order->shipping_address['recipient_name'] ?? '' }}<br>
                    {{ $order->shipping_address['phone'] ?? '' }}<br>
                    {{ $order->shipping_address['address'] ?? '' }}<br>
                    {{ $order->shipping_address['city'] ?? '' }}, {{ $order->shipping_address['postal_code'] ?? '' }}
                </div>
            </div>
        </div>
        @endif

        <div class="footer">
            <p>Terima kasih atas pembelian Anda!</p>
            <p style="margin-top: 5px;">Dicetak pada <span id="print-datetime">{{ now()->translatedFormat('d F Y, H:i:s') }}</span> WIB</p>
        </div>
    </div>

    {{-- Real-time Clock Script --}}
    <script>
        function updatePrintTime() {
            const now = new Date();
            
            // Format waktu Indonesia
            const months = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
            
            const day = now.getDate();
            const month = months[now.getMonth()];
            const year = now.getFullYear();
            const hours = String(now.getHours()).padStart(2, '0');
            const minutes = String(now.getMinutes()).padStart(2, '0');
            const seconds = String(now.getSeconds()).padStart(2, '0');
            
            const dateTimeString = `${day} ${month} ${year}, ${hours}:${minutes}:${seconds}`;
            
            const element = document.getElementById('print-datetime');
            if (element) {
                element.textContent = dateTimeString;
            }
        }
        
        // Update setiap detik
        updatePrintTime();
        setInterval(updatePrintTime, 1000);
    </script>
</body>
</html>

