<x-app-layout>
    <section class="py-10">
        <div class="max-w-6xl mx_auto px-4 sm:px-6 lg:px-8 space-y-6">
            <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
                <div>
                    <h1 class="text-2xl font-semibold text-slate-900">Manajemen Jurnal</h1>
                    <p class="text-sm text-slate-500">Bagikan cerita dan info terbaru untuk pelanggan UMKM.</p>
                </div>
                <a href="{{ route('admin.journals.create') }}" class="inline-flex items-center rounded-full bg-[#C26A3D] px-5 py-3 text-sm font-semibold text-white hover:bg-[#a85327] transition">Tulis Jurnal</a>
            </div>

            <div class="space-y-4">
                @forelse ($journals as $journal)
                    <article class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm">
                        <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
                            <div>
                                <h2 class="text-lg font-semibold text-slate-900">{{ $journal->title }}</h2>
                                <p class="text-xs text-slate-500">{{ $journal->published_at?->format('d M Y, H:i') ?? 'Draft' }}</p>
                            </div>
                            <div class="flex gap-2">
                                <span class="inline-flex items-center rounded-full bg-[#FFE2CF] px-3 py-1 text-[11px] font-semibold text-[#C26A3D]">{{ $journal->is_featured ? 'Featured' : 'Standard' }}</span>
                            </div>
                        </div>
                        <p class="mt-3 h-[48px] overflow-hidden text-sm text-slate-600">{{ $journal->excerpt }}</p>
                        <div class="mt-4 flex gap-3">
                            <a href="{{ route('admin.journals.edit', $journal) }}" class="inline-flex items-center rounded-full border border-[#C26A3D] px-4 py-2 text-xs font-semibold text-[#C26A3D] hover:bg-[#FFE2CF] transition">Edit</a>
                            <form method="POST" action="{{ route('admin.journals.destroy', $journal) }}" onsubmit="return confirm('Hapus artikel ini?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="inline-flex items-center rounded-full border border-rose-300 px-4 py-2 text-xs font-semibold text-rose-600 hover:bg-rose-50 transition">Hapus</button>
                            </form>
                        </div>
                    </article>
                @empty
                    <div class="rounded-3xl border border-[#FAD4C2] bg-white p-12 text-center text-slate-500">
                        Belum ada artikel jurnal.
                    </div>
                @endforelse
            </div>

            <div>
                {{ $journals->onEachSide(1)->links() }}
            </div>
        </div>
    </section>
</x-app-layout>

