<x-admin-layout>
    <x-slot name="pageTitle">Diskon & Promo</x-slot>
    <x-slot name="pageSubtitle">Atur diskon produk dan promo menarik.</x-slot>

    <x-admin.card title="Produk dengan Diskon">
        <div class="mt-4 overflow-hidden rounded-2xl border border-[#FAD4C2]/60 bg-white shadow-sm dark:border-slate-800 dark:bg-slate-900">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-[#FAD4C2]/60 dark:divide-slate-800 text-sm">
                    <thead class="bg-[#FFF0E6] dark:bg-slate-800 text-left text-xs uppercase text-slate-500 dark:text-slate-400">
                        <tr>
                            <th class="px-4 py-3">Produk</th>
                            <th class="px-4 py-3 text-center">Stok</th>
                            <th class="px-4 py-3 text-center">Harga</th>
                            <th class="px-4 py-3 text-center">Harga Setelah Diskon</th>
                            <th class="px-4 py-3 text-center">Diskon</th>
                            <th class="px-4 py-3 text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-[#FAD4C2]/40 dark:divide-slate-800 bg-white dark:bg-slate-900">
                        @if (session('success'))
                            <tr class="bg-[#E8FBF0] text-sm">
                                <td colspan="6" class="px-4 py-3">
                                    <div class="flex items-center justify-between rounded-2xl border border-emerald-200 bg-white/70 px-4 py-3 text-sm font-semibold text-emerald-700 shadow-sm">
                                        <span>{{ session('success') }}</span>
                                        <span class="text-xs font-medium text-emerald-500">Terbaru</span>
                                    </div>
                                </td>
                            </tr>
                        @endif
                        @forelse ($products as $p)
                            <tr class="transition hover:bg-[#FFF7F2] dark:hover:bg-slate-800">
                                <td class="px-4 py-4 font-semibold text-slate-800 dark:text-slate-100">{{ $p->name }}<div class="text-xs text-slate-500">SKU: {{ $p->sku }}</div></td>
                                <td class="px-4 py-4 text-center">{{ $p->stock }}</td>
                                <td class="px-4 py-4 text-center font-semibold text-[#C26A3D]">Rp{{ number_format($p->price, 0, ',', '.') }}</td>
                                <td class="px-4 py-4 text-center font-semibold text-[#C26A3D]">
                                    Rp{{ number_format((int) round($p->price * max(0, 1 - ($p->discount_percent ?? 0) / 100)), 0, ',', '.') }}
                                </td>
                                <td class="px-4 py-4 text-center font-semibold">{{ (float) $p->discount_percent }}%</td>
                                <td class="px-4 py-4 text-center">
                                    <form action="{{ route('admin.discounts.update', $p) }}" method="POST" class="flex items-center justify-center gap-2">
                                        @csrf
                                        @method('PATCH')
                                        <label class="sr-only" for="discount-{{ $p->id }}">Diskon</label>
                                        <div class="relative flex items-center rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-3 py-1 shadow-sm transition focus-within:border-[#C26A3D] focus-within:ring-1 focus-within:ring-[#C26A3D]/50">
                                            <input id="discount-{{ $p->id }}" type="number" name="discount_percent" min="0" max="90" step="0.1" value="{{ old('discount_percent', $p->discount_percent) }}" class="w-20 bg-transparent text-right text-xs font-semibold text-[#C26A3D] focus:outline-none">
                                            <span class="ml-1 text-xs font-semibold text-slate-500">%</span>
                                        </div>
                                        <button type="submit" class="whitespace-nowrap rounded-full bg-gradient-to-r from-[#C26A3D] to-[#F68B35] px-4 py-2 text-xs font-semibold text-white shadow-sm transition hover:opacity-90 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-[#C26A3D]">Simpan</button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr><td colspan="6" class="px-4 py-8 text-center text-slate-500">Belum ada produk.</td></tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        <div class="mt-4">{{ $products->onEachSide(1)->links() }}</div>
    </x-admin.card>
</x-admin-layout>
