<x-admin-layout>
    <x-slot name="pageTitle">Dashboard Admin</x-slot>
    <x-slot name="pageSubtitle">Pantau order, kanal distribusi, dan performa kasir secara realtime.</x-slot>

    @php
        $totalOrdersSafe = max($totalOrders, 1);
        $onlineShare = min(100, max(0, round(($onlineOrders / $totalOrdersSafe) * 100)));
        $offlineShare = min(100, max(0, round(($offlineOrders / $totalOrdersSafe) * 100)));
        $unpaidShare = min(100, max(0, round(($unpaidOrders / $totalOrdersSafe) * 100)));

        $incomeLabels = $incomeChartLabels->isNotEmpty() ? $incomeChartLabels : collect([now()->translatedFormat('M Y')]);
        $incomeTotals = $incomeChartTotals->isNotEmpty() ? $incomeChartTotals : collect([0]);
        $channelLabels = collect($channelChart['labels']);
        $channelValues = collect($channelChart['values']);
    @endphp

    {{-- Welcome Section --}}
    <div class="mb-6 overflow-hidden rounded-2xl bg-gradient-to-r from-blue-600 via-indigo-600 to-purple-600 p-6 shadow-xl relative">
        <div class="absolute inset-0 bg-gradient-to-r from-white/10 to-transparent"></div>
        <div class="relative z-10 flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4">
            <div class="flex-1">
                <h1 class="text-xl sm:text-2xl font-bold text-white drop-shadow-lg">Selamat Datang, {{ auth()->user()->name }}!</h1>
                <p class="mt-1 text-sm text-blue-100" id="dashboard-date">{{ now()->translatedFormat('l, d F Y') }}</p>
            </div>
            <div class="flex items-center gap-3 rounded-xl bg-white/20 backdrop-blur-sm px-4 py-3 border border-white/30">
                <svg class="h-8 w-8 text-white animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <div>
                    <div id="dashboard-clock" class="text-2xl font-bold text-white tabular-nums drop-shadow-lg">--:--:--</div>
                    <div class="text-xs text-blue-100" id="dashboard-tz">Waktu Real-time</div>
                </div>
            </div>
        </div>
    </div>

    <div class="space-y-6">
        {{-- Main Stats - Simplified --}}
        <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-4">
            <x-admin.metric-card title="Penghasilan Bulan Ini" subtitle="{{ now()->translatedFormat('F Y') }}" value="Rp{{ number_format($monthlyIncome, 0, ',', '.') }}" variant="success" />
            <x-admin.metric-card title="Penghasilan Hari Ini" subtitle="{{ now()->translatedFormat('d M') }}" value="Rp{{ number_format($todayIncome, 0, ',', '.') }}" variant="warning" />
            <x-admin.metric-card title="Total Pesanan" subtitle="{{ $todaySales }} penjualan hari ini" value="{{ number_format($totalOrders) }}" variant="primary" href="{{ route('admin.orders.index') }}" />
            <x-admin.metric-card title="Stok Menipis" subtitle="Perlu perhatian" value="{{ number_format($lowStockProducts->count()) }}" variant="danger" href="{{ route('admin.products.index') }}" />
        </div>

        {{-- Charts Section - Simplified --}}
        <div class="grid gap-6 lg:grid-cols-2">
            <x-admin.card title="Distribusi Penjualan" subtitle="Online vs Kasir">
                <div class="mt-4 grid grid-cols-3 gap-3">
                    <div class="rounded-xl bg-gradient-to-br from-blue-50 to-blue-100 dark:from-blue-900/20 dark:to-blue-800/20 p-3 text-center">
                        <p class="text-xs font-semibold text-blue-600 dark:text-blue-300">Online</p>
                        <p class="mt-1 text-xl font-bold text-blue-700 dark:text-blue-200">{{ $onlineOrders }}</p>
                        <p class="text-xs text-blue-500">{{ $onlineShare }}%</p>
                    </div>
                    <div class="rounded-xl bg-gradient-to-br from-emerald-50 to-emerald-100 dark:from-emerald-900/20 dark:to-emerald-800/20 p-3 text-center">
                            <p class="text-xs font-semibold text-emerald-600 dark:text-emerald-300">Kasir</p>
                        <p class="mt-1 text-xl font-bold text-emerald-700 dark:text-emerald-200">{{ $offlineOrders }}</p>
                            <p class="text-xs text-emerald-500">{{ $offlineShare }}%</p>
                        </div>
                    <div class="rounded-xl bg-gradient-to-br from-amber-50 to-amber-100 dark:from-amber-900/20 dark:to-amber-800/20 p-3 text-center">
                        <p class="text-xs font-semibold text-amber-600 dark:text-amber-300">Pending</p>
                        <p class="mt-1 text-xl font-bold text-amber-700 dark:text-amber-200">{{ $unpaidOrders }}</p>
                            <p class="text-xs text-amber-500">{{ $unpaidShare }}%</p>
                    </div>
                </div>
            </x-admin.card>

            <x-admin.card title="Penghasilan Bulanan" subtitle="Tren 6 bulan">
                <div class="mt-4 rounded-xl bg-slate-50 dark:bg-slate-800/50 p-4">
                    <canvas id="incomeChart" class="w-full" height="200"></canvas>
                </div>
            </x-admin.card>
        </div>

        {{-- Orders & Best Sellers - Simplified --}}
        <div class="grid gap-6 lg:grid-cols-2">
            <x-admin.card title="Pesanan Menunggu">
                <x-slot name="actions">
                    <div class="flex gap-2">
                        <a href="{{ route('cashier.dashboard') }}" class="inline-flex items-center gap-1 rounded-lg bg-[#C26A3D] px-3 py-1.5 text-xs font-semibold text-white transition hover:bg-[#a85327]">
                            <svg class="h-3.5 w-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                            </svg>
                            Kasir
                        </a>
                        <a href="{{ route('admin.orders.index') }}" class="inline-flex items-center rounded-lg border border-[#C26A3D] px-3 py-1.5 text-xs font-semibold text-[#C26A3D] transition hover:bg-[#FFE2CF]">Semua</a>
                    </div>
                </x-slot>

                <div class="mt-4 space-y-2">
                    @forelse ($waitingOrders->take(5) as $order)
                        <div class="flex items-center justify-between rounded-lg border border-slate-200 dark:border-slate-700 bg-white dark:bg-slate-800/50 p-3 transition hover:border-slate-300 dark:hover:border-slate-600">
                            <div class="flex-1">
                                <p class="font-semibold text-slate-800 dark:text-slate-200 text-sm">{{ $order->invoice_number }}</p>
                                <p class="text-xs text-slate-500 dark:text-slate-400">{{ $order->created_at->translatedFormat('d M, H:i') }}</p>
                            </div>
                            <div class="text-right">
                                <p class="font-bold text-[#C26A3D] text-sm">Rp{{ number_format($order->grand_total, 0, ',', '.') }}</p>
                                <a href="{{ route('admin.orders.detail', $order) }}" class="text-xs text-blue-600 hover:text-blue-700">Detail →</a>
                            </div>
                        </div>
                            @empty
                        <div class="py-8 text-center">
                            <p class="text-sm text-slate-500 dark:text-slate-400">Tidak ada pesanan menunggu</p>
                        </div>
                            @endforelse
                </div>
            </x-admin.card>

            <x-admin.card title="Produk Terlaris" subtitle="Top 5">
                <div class="mt-4 space-y-2">
                    @forelse ($bestSellers as $index => $product)
                        <div class="flex items-center gap-3 rounded-lg border border-slate-200 dark:border-slate-700 bg-white dark:bg-slate-800/50 p-3">
                            <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-gradient-to-br {{ $index === 0 ? 'from-yellow-400 to-orange-500' : 'from-blue-500 to-purple-600' }} text-xs font-bold text-white">
                                #{{ $index + 1 }}
                            </div>
                            <div class="flex-1 min-w-0">
                                <p class="font-semibold text-slate-800 dark:text-slate-200 text-sm truncate">{{ $product->name }}</p>
                                <p class="text-xs text-slate-500 dark:text-slate-400">{{ $product->category?->name ?? 'Tanpa kategori' }}</p>
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-bold text-emerald-600">{{ $product->sold_quantity ?? 0 }}</p>
                                <p class="text-xs text-slate-500">terjual</p>
                            </div>
                        </div>
                    @empty
                        <div class="py-8 text-center">
                            <p class="text-sm text-slate-500 dark:text-slate-400">Belum ada data penjualan</p>
                        </div>
                    @endforelse
                </div>
            </x-admin.card>
        </div>

    </div>

    @push('scripts')
        <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.7/dist/chart.umd.min.js"></script>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const clockElement = document.getElementById('dashboard-clock');
                const dateElement = document.getElementById('dashboard-date');
                const tzElement = document.getElementById('dashboard-tz');

                const updateDashboardClock = () => {
                    const now = new Date();
                    const hours = String(now.getHours()).padStart(2, '0');
                    const minutes = String(now.getMinutes()).padStart(2, '0');
                    const seconds = String(now.getSeconds()).padStart(2, '0');
                    const timeString = `${hours}:${minutes}:${seconds}`;

                    const dateString = now.toLocaleDateString('id-ID', {
                        weekday: 'long',
                        day: '2-digit',
                        month: 'long',
                        year: 'numeric',
                    });

                    const tz = Intl.DateTimeFormat().resolvedOptions().timeZone || 'Waktu setempat';
                    const offsetMinutes = now.getTimezoneOffset() * -1;
                    const offsetHours = Math.floor(offsetMinutes / 60);
                    const offsetMin = Math.abs(offsetMinutes % 60);
                    const offsetLabel = `UTC${offsetHours >= 0 ? '+' : ''}${offsetHours}${offsetMin ? ':' + String(offsetMin).padStart(2, '0') : ''}`;
                    const tzLabel = `${tz} (${offsetLabel})`;

                    if (clockElement) clockElement.textContent = timeString;
                    if (dateElement) dateElement.textContent = dateString;
                    if (tzElement) tzElement.textContent = tzLabel;
                };

                updateDashboardClock();
                setInterval(updateDashboardClock, 1000);

                // Income Chart
                const incomeCtx = document.getElementById('incomeChart');
                if (incomeCtx) {
                    new Chart(incomeCtx, {
                        type: 'line',
                        data: {
                            labels: @json($incomeLabels),
                            datasets: [{
                                label: 'Penghasilan',
                                data: @json($incomeTotals),
                                borderColor: '#3b82f6',
                                backgroundColor: 'rgba(59, 130, 246, 0.1)',
                                borderWidth: 2,
                                fill: true,
                                tension: 0.4,
                                pointRadius: 3,
                                pointBackgroundColor: '#3b82f6',
                                pointBorderColor: '#fff',
                                pointBorderWidth: 2,
                            }],
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: false,
                            plugins: { 
                                legend: { display: false },
                                tooltip: {
                                    backgroundColor: 'rgba(0, 0, 0, 0.8)',
                                    padding: 12,
                                    titleFont: { size: 13, weight: 'bold' },
                                    bodyFont: { size: 12 },
                                    callbacks: {
                                        label: function(context) {
                                            return 'Rp ' + new Intl.NumberFormat('id-ID').format(context.parsed.y);
                                        }
                                    }
                                }
                            },
                            scales: {
                                y: {
                                    beginAtZero: true,
                                    ticks: {
                                        font: { size: 11 },
                                        callback: function(value) {
                                            if (value >= 1000000) {
                                                return 'Rp' + (value / 1000000).toFixed(1) + 'Jt';
                                            } else if (value >= 1000) {
                                                return 'Rp' + (value / 1000).toFixed(0) + 'Rb';
                                            }
                                            return 'Rp' + value;
                                        },
                                    },
                                    grid: { 
                                        color: 'rgba(148, 163, 184, 0.1)',
                                        borderDash: [3, 3]
                                    },
                                },
                                x: { 
                                    ticks: { 
                                        font: { size: 11 },
                                        maxRotation: 0,
                                        minRotation: 0
                                    },
                                    grid: { display: false },
                                },
                            },
                        },
                    });
                }
            });
        </script>
    @endpush
</x-admin-layout>









