<x-admin-layout>
    <x-slot name="pageTitle">Kategori Produk</x-slot>
    <x-slot name="pageSubtitle">Kelola kategori, urutan tampil, dan visibilitas.</x-slot>

    <div class="space-y-6">
        <div class="grid gap-4 md:grid-cols-3">
            <div class="rounded-3xl border border-[#FAD4C2] bg-white dark:bg-slate-900 p-6 shadow-sm">
                <p class="text-xs font-semibold uppercase tracking-wide text-slate-500 dark:text-slate-400">Total Kategori</p>
                <p class="mt-2 text-3xl font-bold text-slate-900 dark:text-slate-100">{{ $stats['total'] }}</p>
            </div>
            <div class="rounded-3xl border border-[#FAD4C2] bg-white dark:bg-slate-900 p-6 shadow-sm">
                <p class="text-xs font-semibold uppercase tracking-wide text-slate-500 dark:text-slate-400">Aktif</p>
                <p class="mt-2 text-3xl font-bold text-emerald-600">{{ $stats['active'] }}</p>
            </div>
            <div class="rounded-3xl border border-[#FAD4C2] bg-white dark:bg-slate-900 p-6 shadow-sm">
                <p class="text-xs font-semibold uppercase tracking-wide text-slate-500 dark:text-slate-400">Nonaktif</p>
                <p class="mt-2 text-3xl font-bold text-slate-600 dark:text-slate-400">{{ $stats['inactive'] }}</p>
            </div>
        </div>

        <div class="flex flex-col gap-4 md:flex-row md:items-center md:justify-between">
            <div class="flex flex-1 items-center gap-3">
                <form method="GET" action="{{ route('admin.categories.index') }}" class="flex-1">
                    <div class="relative">
                        <input type="text" name="search" value="{{ $filters['search'] }}" placeholder="Cari kategori..." class="w-full rounded-xl border border-[#FAD4C2] bg-white dark:bg-slate-800 px-4 py-2.5 pl-10 pr-4 text-sm focus:outline-none focus:ring-2 focus:ring-[#C26A3D]">
                        <svg class="absolute left-3 top-1/2 h-5 w-5 -translate-y-1/2 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                    </div>
                    @if ($filters['status'] !== 'all')
                        <input type="hidden" name="status" value="{{ $filters['status'] }}">
                    @endif
                </form>
                <form method="GET" action="{{ route('admin.categories.index') }}">
                    <select name="status" onchange="this.form.submit()" class="rounded-xl border border-[#FAD4C2] bg-white dark:bg-slate-800 px-4 py-2.5 text-sm focus:outline-none focus:ring-2 focus:ring-[#C26A3D]">
                        <option value="all" {{ $filters['status'] === 'all' ? 'selected' : '' }}>Semua Status</option>
                        <option value="active" {{ $filters['status'] === 'active' ? 'selected' : '' }}>Aktif</option>
                        <option value="inactive" {{ $filters['status'] === 'inactive' ? 'selected' : '' }}>Nonaktif</option>
                    </select>
                    @if ($filters['search'])
                        <input type="hidden" name="search" value="{{ $filters['search'] }}">
                    @endif
                </form>
            </div>
            <a href="{{ route('admin.categories.create') }}" class="inline-flex items-center justify-center gap-2 rounded-xl bg-[#C26A3D] px-5 py-2.5 text-sm font-semibold text-white transition hover:bg-[#a85327]">
                <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                </svg>
                Tambah Kategori
            </a>
        </div>

        @if (session('status'))
            <div class="rounded-xl border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-700">
                {{ session('status') }}
            </div>
        @endif

        @error('category')
            <div class="rounded-xl border border-rose-200 bg-rose-50 px-4 py-3 text-sm text-rose-700">
                {{ $message }}
            </div>
        @enderror

        <div class="hidden overflow-hidden rounded-3xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 shadow-lg shadow-[#FAD4C2]/30 md:block">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-[#FAD4C2]/60 dark:divide-slate-800 text-sm text-slate-600 dark:text-slate-300">
                    <thead class="bg-[#FFF0E6] dark:bg-slate-800 text-xs font-semibold uppercase tracking-wider text-slate-500 dark:text-slate-400">
                        <tr>
                            <th colspan="2" class="px-6 py-4 text-left">Kategori</th>
                            <th class="px-6 py-4 text-left">Tagline</th>
                            <th class="px-6 py-4 text-center">Produk</th>
                            <th class="px-6 py-4 text-center">Aktif</th>
                            <th class="px-6 py-4 text-center">Urutan</th>
                            <th class="px-6 py-4 text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-[#FAD4C2]/50 dark:divide-slate-800 bg-white dark:bg-slate-900">
                        @forelse ($categories as $category)
                            <tr class="transition hover:bg-[#FFF7F2] dark:hover:bg-slate-800">
                                <td class="px-6 py-5 w-20">
                                    <div class="h-12 w-12 overflow-hidden rounded-2xl border border-[#FAD4C2]/80 bg-[#FFF8F3]">
                                        <img src="{{ $category->hero_image_url ?? $category->carousel_image_url ?? 'https://images.unsplash.com/photo-1505740106531-4243f3831f3f?auto=format&fit=crop&w=1500&q=80' }}" alt="{{ $category->name }}" class="h-full w-full object-cover">
                                    </div>
                                </td>
                                <td class="px-6 py-5 font-semibold text-slate-800 dark:text-slate-100">{{ $category->name }}</td>
                                <td class="px-6 py-5">{{ $category->tagline ?? '-' }}</td>
                                <td class="px-6 py-5 text-center">
                                    <span class="inline-flex items-center rounded-full bg-slate-100 dark:bg-slate-800 px-3 py-1 text-xs font-semibold text-slate-600 dark:text-slate-400">
                                        {{ $category->products()->count() }}
                                    </span>
                                </td>
                                <td class="px-6 py-5 text-center">
                                    <span class="inline-flex items-center rounded-full {{ $category->is_active ? 'bg-emerald-100 text-emerald-700 dark:bg-emerald-900/30 dark:text-emerald-400' : 'bg-slate-100 text-slate-600 dark:bg-slate-800 dark:text-slate-400' }} px-3 py-1 text-[11px] font-semibold">
                                        {{ $category->is_active ? 'Aktif' : 'Nonaktif' }}
                                    </span>
                                </td>
                                <td class="px-6 py-5 text-center">{{ $category->display_order }}</td>
                                <td class="px-6 py-5 text-center">
                                    <div class="inline-flex gap-2">
                                        <a href="{{ route('admin.categories.edit', $category) }}" class="inline-flex items-center rounded-full border border-[#C26A3D] px-4 py-2 text-xs font-semibold text-[#C26A3D] transition hover:bg-[#FFE2CF]">Edit</a>
                                        <form method="POST" action="{{ route('admin.categories.destroy', $category) }}" onsubmit="return confirm('Hapus kategori ini? Pastikan tidak ada produk yang menggunakan kategori ini.');" class="inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="inline-flex items-center rounded-full border border-rose-300 px-4 py-2 text-xs font-semibold text-rose-600 transition hover:bg-rose-50">Hapus</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="px-6 py-10 text-center text-slate-500">Belum ada kategori.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <div class="space-y-4 md:hidden">
            @forelse ($categories as $category)
                <div class="rounded-3xl border border-[#FAD4C2] bg-white dark:bg-slate-900 p-4 shadow-sm">
                    <div class="flex items-start gap-4">
                        <div class="h-16 w-16 flex-shrink-0 overflow-hidden rounded-2xl border border-[#FAD4C2]/80 bg-[#FFF8F3]">
                            <img src="{{ $category->hero_image_url ?? $category->carousel_image_url ?? 'https://images.unsplash.com/photo-1505740106531-4243f3831f3f?auto=format&fit=crop&w=1500&q=80' }}" alt="{{ $category->name }}" class="h-full w-full object-cover">
                        </div>
                        <div class="flex-1 min-w-0">
                            <h3 class="font-semibold text-slate-900 dark:text-slate-100">{{ $category->name }}</h3>
                            <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">{{ $category->tagline ?? '-' }}</p>
                            <div class="mt-2 flex flex-wrap items-center gap-2">
                                <span class="inline-flex items-center rounded-full {{ $category->is_active ? 'bg-emerald-100 text-emerald-700 dark:bg-emerald-900/30 dark:text-emerald-400' : 'bg-slate-100 text-slate-600 dark:bg-slate-800 dark:text-slate-400' }} px-2 py-1 text-[10px] font-semibold">
                                    {{ $category->is_active ? 'Aktif' : 'Nonaktif' }}
                                </span>
                                <span class="text-xs text-slate-500 dark:text-slate-400">{{ $category->products()->count() }} produk</span>
                                <span class="text-xs text-slate-500 dark:text-slate-400">Urutan: {{ $category->display_order }}</span>
                            </div>
                            <div class="mt-3 flex gap-2">
                                <a href="{{ route('admin.categories.edit', $category) }}" class="flex-1 rounded-lg border border-[#C26A3D] bg-white px-3 py-2 text-center text-xs font-semibold text-[#C26A3D]">Edit</a>
                                <form method="POST" action="{{ route('admin.categories.destroy', $category) }}" onsubmit="return confirm('Hapus kategori ini? Pastikan tidak ada produk yang menggunakan kategori ini.');" class="flex-1">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="w-full rounded-lg border border-rose-300 bg-white px-3 py-2 text-xs font-semibold text-rose-600">Hapus</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            @empty
                <div class="rounded-3xl border border-[#FAD4C2] bg-white dark:bg-slate-900 p-8 text-center">
                    <p class="text-slate-500 dark:text-slate-400">Belum ada kategori.</p>
                </div>
            @endforelse
        </div>

        <div>
            {{ $categories->onEachSide(1)->links() }}
        </div>
    </div>
</x-admin-layout>
