<x-admin-layout>
    <x-slot name="pageTitle">Edit Kategori</x-slot>
    <x-slot name="pageSubtitle">Perbarui informasi kategori produk.</x-slot>

    <div class="space-y-6">
        <form action="{{ route('admin.categories.update', $category) }}" method="POST" enctype="multipart/form-data" class="space-y-6">
            @csrf
            @method('PATCH')
            <div class="rounded-3xl border border-[#FAD4C2] bg-white dark:bg-slate-900 p-6 shadow-sm">
                <h2 class="mb-4 text-lg font-semibold text-slate-900 dark:text-slate-100">Informasi Dasar</h2>
                <div class="grid gap-5 md:grid-cols-2">
                    <div>
                        <label class="block text-sm font-semibold text-slate-700 dark:text-slate-300 mb-2">Nama Kategori <span class="text-rose-500">*</span></label>
                        <input type="text" name="name" value="{{ old('name', $category->name) }}" required class="w-full rounded-xl border border-[#FAD4C2] bg-white dark:bg-slate-800 px-4 py-2.5 text-sm focus:outline-none focus:ring-2 focus:ring-[#C26A3D]">
                        @error('name')
                            <p class="mt-1 text-xs text-rose-600">{{ $message }}</p>
                        @enderror
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-slate-700 dark:text-slate-300 mb-2">Tagline</label>
                        <input type="text" name="tagline" value="{{ old('tagline', $category->tagline) }}" class="w-full rounded-xl border border-[#FAD4C2] bg-white dark:bg-slate-800 px-4 py-2.5 text-sm focus:outline-none focus:ring-2 focus:ring-[#C26A3D]">
                        @error('tagline')
                            <p class="mt-1 text-xs text-rose-600">{{ $message }}</p>
                        @enderror
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm font-semibold text-slate-700 dark:text-slate-300 mb-2">Deskripsi</label>
                        <textarea name="description" rows="4" class="w-full rounded-xl border border-[#FAD4C2] bg-white dark:bg-slate-800 px-4 py-2.5 text-sm focus:outline-none focus:ring-2 focus:ring-[#C26A3D]">{{ old('description', $category->description) }}</textarea>
                        <p class="mt-1 text-xs text-slate-500">Maksimal 1000 karakter.</p>
                        @error('description')
                            <p class="mt-1 text-xs text-rose-600">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="rounded-3xl border border-[#FAD4C2] bg-white dark:bg-slate-900 p-6 shadow-sm">
                <h2 class="mb-4 text-lg font-semibold text-slate-900 dark:text-slate-100">Gambar</h2>
                <div class="grid gap-5 md:grid-cols-2">
                    <div>
                        <label class="block text-sm font-semibold text-slate-700 dark:text-slate-300 mb-2">Hero Image</label>
                        @if ($category->hero_image_url)
                            <div class="mb-3">
                                <img src="{{ $category->hero_image_url }}" alt="Current hero image" class="h-32 w-full rounded-xl object-cover border border-[#FAD4C2]">
                            </div>
                        @endif
                        <div class="space-y-2">
                            <input type="file" name="hero_image" accept="image/*" id="hero_image_file" class="w-full rounded-xl border border-[#FAD4C2] bg-white dark:bg-slate-800 px-4 py-2.5 text-sm focus:outline-none focus:ring-2 focus:ring-[#C26A3D]">
                            <p class="text-xs text-slate-500 text-center">Atau</p>
                            <input type="url" name="hero_image_url" value="{{ old('hero_image_url') }}" placeholder="https://..." class="w-full rounded-xl border border-[#FAD4C2] bg-white dark:bg-slate-800 px-4 py-2.5 text-sm focus:outline-none focus:ring-2 focus:ring-[#C26A3D]">
                        </div>
                        <p class="mt-1 text-xs text-slate-500">Biarkan kosong jika tidak ingin mengganti gambar.</p>
                        <div id="hero_preview" class="mt-3 hidden">
                            <img src="" alt="Preview" class="h-32 w-full rounded-xl object-cover border border-[#FAD4C2]">
                        </div>
                        @error('hero_image')
                            <p class="mt-1 text-xs text-rose-600">{{ $message }}</p>
                        @enderror
                        @error('hero_image_url')
                            <p class="mt-1 text-xs text-rose-600">{{ $message }}</p>
                        @enderror
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-slate-700 dark:text-slate-300 mb-2">Carousel Image</label>
                        @if ($category->carousel_image_url)
                            <div class="mb-3">
                                <img src="{{ $category->carousel_image_url }}" alt="Current carousel image" class="h-32 w-full rounded-xl object-cover border border-[#FAD4C2]">
                            </div>
                        @endif
                        <div class="space-y-2">
                            <input type="file" name="carousel_image" accept="image/*" id="carousel_image_file" class="w-full rounded-xl border border-[#FAD4C2] bg-white dark:bg-slate-800 px-4 py-2.5 text-sm focus:outline-none focus:ring-2 focus:ring-[#C26A3D]">
                            <p class="text-xs text-slate-500 text-center">Atau</p>
                            <input type="url" name="carousel_image_url" value="{{ old('carousel_image_url') }}" placeholder="https://..." class="w-full rounded-xl border border-[#FAD4C2] bg-white dark:bg-slate-800 px-4 py-2.5 text-sm focus:outline-none focus:ring-2 focus:ring-[#C26A3D]">
                        </div>
                        <p class="mt-1 text-xs text-slate-500">Gambar untuk carousel kategori.</p>
                        <div id="carousel_preview" class="mt-3 hidden">
                            <img src="" alt="Preview" class="h-32 w-full rounded-xl object-cover border border-[#FAD4C2]">
                        </div>
                        @error('carousel_image')
                            <p class="mt-1 text-xs text-rose-600">{{ $message }}</p>
                        @enderror
                        @error('carousel_image_url')
                            <p class="mt-1 text-xs text-rose-600">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="rounded-3xl border border-[#FAD4C2] bg-white dark:bg-slate-900 p-6 shadow-sm">
                <h2 class="mb-4 text-lg font-semibold text-slate-900 dark:text-slate-100">Pengaturan</h2>
                <div class="grid gap-5 md:grid-cols-2">
                    <div>
                        <label class="block text-sm font-semibold text-slate-700 dark:text-slate-300 mb-2">Urutan Tampil</label>
                        <input type="number" name="display_order" value="{{ old('display_order', $category->display_order) }}" min="0" class="w-full rounded-xl border border-[#FAD4C2] bg-white dark:bg-slate-800 px-4 py-2.5 text-sm focus:outline-none focus:ring-2 focus:ring-[#C26A3D]">
                        @error('display_order')
                            <p class="mt-1 text-xs text-rose-600">{{ $message }}</p>
                        @enderror
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-slate-700 dark:text-slate-300 mb-2">Status</label>
                        <label class="inline-flex items-center gap-2 rounded-xl border border-[#FAD4C2] bg-white dark:bg-slate-800 px-4 py-2.5 text-sm">
                            <input type="checkbox" name="is_active" value="1" class="rounded border-slate-300 text-[#C26A3D] focus:ring-[#C26A3D]" {{ old('is_active', $category->is_active) ? 'checked' : '' }}>
                            <span>Tampilkan di katalog</span>
                        </label>
                    </div>
                </div>
            </div>

            <div class="flex justify-end gap-3">
                <a href="{{ route('admin.categories.index') }}" class="inline-flex items-center rounded-xl border border-[#FAD4C2] bg-white dark:bg-slate-800 px-5 py-2.5 text-sm font-semibold text-slate-700 dark:text-slate-300 hover:bg-slate-50 dark:hover:bg-slate-700">Batal</a>
                <button type="submit" class="inline-flex items-center rounded-xl bg-[#C26A3D] px-5 py-2.5 text-sm font-semibold text-white hover:bg-[#a85327]">Simpan Perubahan</button>
            </div>
        </form>
    </div>

    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    preview.querySelector('img').src = e.target.result;
                    preview.classList.remove('hidden');
                };
                reader.readAsDataURL(input.files[0]);
            }
        }

        document.getElementById('hero_image_file')?.addEventListener('change', function() {
            previewImage(this, 'hero_preview');
        });

        document.getElementById('carousel_image_file')?.addEventListener('change', function() {
            previewImage(this, 'carousel_preview');
        });

        document.querySelector('input[name="hero_image_url"]')?.addEventListener('blur', function() {
            const preview = document.getElementById('hero_preview');
            if (this.value) {
                preview.querySelector('img').src = this.value;
                preview.classList.remove('hidden');
            }
        });

        document.querySelector('input[name="carousel_image_url"]')?.addEventListener('blur', function() {
            const preview = document.getElementById('carousel_preview');
            if (this.value) {
                preview.querySelector('img').src = this.value;
                preview.classList.remove('hidden');
            }
        });
    </script>
</x-admin-layout>
