<x-admin-layout>
    <x-slot name="pageTitle">Laporan Kasir Offline</x-slot>
    <x-slot name="pageSubtitle">Analisis lengkap transaksi dan performa kasir offline</x-slot>

    <div class="space-y-6">
        <!-- Header Action -->
        <div class="flex items-center justify-end">
            <a href="{{ route('cashier.login') }}" target="_blank" class="inline-flex items-center gap-2 rounded-xl border-2 border-[#C26A3D] bg-white px-4 py-2.5 text-sm font-semibold text-[#C26A3D] hover:bg-[#FFE2CF] transition">
                <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                </svg>
                Buka Kasir POS
            </a>
        </div>

        <!-- Statistik Cards -->
        <div class="grid gap-4 md:grid-cols-2 lg:grid-cols-4">
            <div class="rounded-2xl bg-gradient-to-br from-blue-500 to-blue-600 p-6 text-white shadow-lg">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-blue-100">Transaksi Hari Ini</p>
                        <p class="mt-2 text-3xl font-bold">{{ number_format($todayOfflineOrders) }}</p>
                        <p class="mt-1 text-xs text-blue-100">Pesanan via kasir offline</p>
                    </div>
                    <div class="rounded-full bg-white/20 p-3">
                        <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                    </div>
                </div>
            </div>

            <div class="rounded-2xl bg-gradient-to-br from-green-500 to-green-600 p-6 text-white shadow-lg">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-green-100">Pendapatan Hari Ini</p>
                        <p class="mt-2 text-3xl font-bold">Rp{{ number_format($todayOfflineRevenue, 0, ',', '.') }}</p>
                        <p class="mt-1 text-xs text-green-100">Dari transaksi kasir</p>
                    </div>
                    <div class="rounded-full bg-white/20 p-3">
                        <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>
            </div>

            <div class="rounded-2xl bg-gradient-to-br from-purple-500 to-purple-600 p-6 text-white shadow-lg">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-purple-100">Transaksi Bulan Ini</p>
                        <p class="mt-2 text-3xl font-bold">{{ number_format($monthOfflineOrders) }}</p>
                        <p class="mt-1 text-xs text-purple-100">Pesanan offline</p>
                    </div>
                    <div class="rounded-full bg-white/20 p-3">
                        <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 8v8m-4-5v5m-4-2v2m-2 4h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                </div>
            </div>

            <div class="rounded-2xl bg-gradient-to-br from-orange-500 to-orange-600 p-6 text-white shadow-lg">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-orange-100">Pendapatan Bulan Ini</p>
                        <p class="mt-2 text-3xl font-bold">Rp{{ number_format($monthOfflineRevenue, 0, ',', '.') }}</p>
                        <p class="mt-1 text-xs text-orange-100">Dari kasir offline</p>
                    </div>
                    <div class="rounded-full bg-white/20 p-3">
                        <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                        </svg>
                    </div>
                </div>
            </div>
        </div>

        <!-- Grafik & Statistik Detail -->
        <div class="grid gap-6 lg:grid-cols-2">
            <!-- Grafik Transaksi Harian -->
            <div class="rounded-2xl border border-[#FAD4C2] bg-white p-6 shadow-sm">
                <h3 class="text-lg font-semibold text-slate-900 mb-4">Transaksi 7 Hari Terakhir</h3>
                <div class="space-y-4">
                    @foreach($dailyStats as $stat)
                        <div class="flex items-center gap-4">
                            <div class="w-20 text-sm font-medium text-slate-600">
                                {{ $stat['day'] }}<br>
                                <span class="text-xs text-slate-400">{{ $stat['label'] }}</span>
                            </div>
                            <div class="flex-1">
                                <div class="flex items-center justify-between mb-1">
                                    <span class="text-sm font-semibold text-slate-900">{{ $stat['orders'] }} transaksi</span>
                                    <span class="text-sm font-semibold text-green-600">Rp{{ number_format($stat['revenue'], 0, ',', '.') }}</span>
                                </div>
                                <div class="h-2 rounded-full bg-slate-100 overflow-hidden">
                                    <div class="h-full bg-gradient-to-r from-blue-500 to-green-500 rounded-full transition-all" style="width: {{ $stat['orders'] > 0 ? min(($stat['orders'] / max($dailyStats->max('orders'), 1)) * 100, 100) : 0 }}%"></div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- Status Pembayaran & Rata-rata -->
            <div class="rounded-2xl border border-[#FAD4C2] bg-white p-6 shadow-sm">
                <h3 class="text-lg font-semibold text-slate-900 mb-4">Statistik Pembayaran</h3>
                <div class="space-y-4">
                    <div class="flex items-center justify-between p-4 rounded-xl bg-green-50 border border-green-200">
                        <div class="flex items-center gap-3">
                            <div class="rounded-full bg-green-500 p-2">
                                <svg class="h-5 w-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                </svg>
                            </div>
                            <div>
                                <p class="text-sm font-semibold text-slate-900">Lunas</p>
                                <p class="text-xs text-slate-600">Sudah dibayar</p>
                            </div>
                        </div>
                        <span class="text-xl font-bold text-green-600">{{ number_format($paymentStatusStats['paid']) }}</span>
                    </div>

                    <div class="flex items-center justify-between p-4 rounded-xl bg-yellow-50 border border-yellow-200">
                        <div class="flex items-center gap-3">
                            <div class="rounded-full bg-yellow-500 p-2">
                                <svg class="h-5 w-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                            </div>
                            <div>
                                <p class="text-sm font-semibold text-slate-900">Menunggu Konfirmasi</p>
                                <p class="text-xs text-slate-600">Perlu tindak lanjut</p>
                            </div>
                        </div>
                        <span class="text-xl font-bold text-yellow-600">{{ number_format($paymentStatusStats['awaiting_confirmation']) }}</span>
                    </div>

                    <div class="flex items-center justify-between p-4 rounded-xl bg-red-50 border border-red-200">
                        <div class="flex items-center gap-3">
                            <div class="rounded-full bg-red-500 p-2">
                                <svg class="h-5 w-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                </svg>
                            </div>
                            <div>
                                <p class="text-sm font-semibold text-slate-900">Belum Lunas</p>
                                <p class="text-xs text-slate-600">Belum dibayar</p>
                            </div>
                        </div>
                        <span class="text-xl font-bold text-red-600">{{ number_format($paymentStatusStats['unpaid']) }}</span>
                    </div>
                </div>

                <div class="mt-6 pt-6 border-t border-[#FAD4C2]">
                    <h4 class="text-sm font-semibold text-slate-900 mb-3">Rata-rata Harian (Bulan Ini)</h4>
                    <div class="grid grid-cols-2 gap-4">
                        <div class="text-center p-3 rounded-xl bg-blue-50">
                            <p class="text-2xl font-bold text-blue-600">{{ number_format($avgDailyOrders, 1) }}</p>
                            <p class="text-xs text-slate-600">Transaksi/hari</p>
                        </div>
                        <div class="text-center p-3 rounded-xl bg-green-50">
                            <p class="text-2xl font-bold text-green-600">Rp{{ number_format($avgDailyRevenue, 0, ',', '.') }}</p>
                            <p class="text-xs text-slate-600">Pendapatan/hari</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top Kasir & Produk Terlaris -->
        <div class="grid gap-6 lg:grid-cols-2">
            <!-- Top Kasir -->
            <div class="rounded-2xl border border-[#FAD4C2] bg-white p-6 shadow-sm">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold text-slate-900">Top Kasir</h3>
                    <span class="text-xs text-slate-500">Berdasarkan pendapatan</span>
                </div>
                <div class="space-y-3">
                    @forelse($cashierStats as $index => $cashier)
                        <div class="flex items-center gap-4 p-3 rounded-xl bg-[#FFF8F3] hover:bg-[#FFE2CF] transition">
                                    <div class="flex h-10 w-10 items-center justify-center rounded-full bg-gradient-to-br from-[#C26A3D] to-orange-500 text-white font-bold shadow-md">
                                        {{ $index + 1 }}
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <p class="text-sm font-semibold text-slate-900 truncate">{{ $cashier->name }}</p>
                                        <p class="text-xs text-slate-600">{{ number_format($cashier->offline_orders_count) }} transaksi</p>
                                    </div>
                                    <div class="text-right">
                                        <p class="text-sm font-bold text-green-600">Rp{{ number_format($cashier->offline_revenue, 0, ',', '.') }}</p>
                                        <p class="text-xs text-slate-500">Pendapatan</p>
                                    </div>
                        </div>
                    @empty
                        <div class="text-center py-8 text-slate-500">
                            <svg class="h-12 w-12 mx-auto mb-2 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                            <p class="text-sm">Belum ada data kasir</p>
                        </div>
                    @endforelse
                </div>
            </div>

            <!-- Produk Terlaris di Kasir -->
            <div class="rounded-2xl border border-[#FAD4C2] bg-white p-6 shadow-sm">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold text-slate-900">Produk Terlaris di Kasir</h3>
                    <span class="text-xs text-slate-500">10 teratas</span>
                </div>
                <div class="space-y-3">
                    @forelse($topProducts as $index => $product)
                        <div class="flex items-center gap-4 p-3 rounded-xl bg-[#FFF8F3] hover:bg-[#FFE2CF] transition">
                            <div class="flex h-10 w-10 items-center justify-center rounded-full bg-gradient-to-br from-[#C26A3D] to-orange-500 text-white text-xs font-bold shadow-md">
                                {{ $index + 1 }}
                            </div>
                            <div class="flex-1 min-w-0">
                                <p class="text-sm font-semibold text-slate-900 truncate">{{ $product->name }}</p>
                                <p class="text-xs text-slate-600">Terjual {{ number_format($product->total_sold ?? 0) }} unit</p>
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-bold text-[#C26A3D]">Rp{{ number_format($product->final_price ?? $product->price ?? 0, 0, ',', '.') }}</p>
                                <p class="text-xs text-slate-500">Harga</p>
                            </div>
                        </div>
                    @empty
                        <div class="text-center py-8 text-slate-500">
                            <svg class="h-12 w-12 mx-auto mb-2 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                            </svg>
                            <p class="text-sm">Belum ada data produk</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>

        <!-- Transaksi Terbaru -->
        <div class="rounded-2xl border border-[#FAD4C2] bg-white shadow-sm">
            <div class="border-b border-[#FAD4C2] p-6">
                <h3 class="text-lg font-semibold text-slate-900">Transaksi Terbaru</h3>
                <p class="mt-1 text-sm text-slate-600">10 transaksi kasir terakhir</p>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-[#FFF8F3] border-b border-[#FAD4C2]">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-slate-700">Invoice</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-slate-700">Pelanggan</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-slate-700">Kasir</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-slate-700">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-slate-700">Pembayaran</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-slate-700">Total</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-slate-700">Tanggal</th>
                            <th class="px-6 py-3 text-right text-xs font-semibold uppercase tracking-wider text-slate-700">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-[#FAD4C2]">
                        @forelse($recentOrders as $order)
                            <tr class="hover:bg-[#FFF8F3] transition">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="text-sm font-semibold text-slate-900">{{ $order->invoice_number }}</span>
                                </td>
                                <td class="px-6 py-4">
                                    <span class="text-sm text-slate-900">{{ $order->customer_name ?? 'Pelanggan Umum' }}</span>
                                </td>
                                <td class="px-6 py-4">
                                    <span class="text-sm text-slate-600">{{ $order->cashier->name ?? '-' }}</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex rounded-full px-2.5 py-1 text-xs font-semibold
                                        @if($order->status === 'completed') bg-green-100 text-green-700
                                        @elseif($order->status === 'pending') bg-yellow-100 text-yellow-700
                                        @else bg-blue-100 text-blue-700
                                        @endif">
                                        {{ strtoupper($order->status) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex rounded-full px-2.5 py-1 text-xs font-semibold
                                        @if($order->payment_status === 'paid') bg-green-100 text-green-700
                                        @elseif($order->payment_status === 'unpaid') bg-red-100 text-red-700
                                        @else bg-yellow-100 text-yellow-700
                                        @endif">
                                        {{ strtoupper($order->payment_status) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="text-sm font-semibold text-slate-900">Rp{{ number_format($order->grand_total, 0, ',', '.') }}</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="text-sm text-slate-600">{{ $order->created_at->format('d M Y, H:i') }}</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right">
                                    <a href="{{ route('admin.orders.index', ['invoice' => $order->invoice_number]) }}" class="inline-flex items-center rounded-lg bg-[#C26A3D] px-3 py-1.5 text-xs font-semibold text-white hover:bg-[#a85327] transition">
                                        Detail
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="px-6 py-12 text-center text-slate-500">
                                    <svg class="h-12 w-12 mx-auto mb-2 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                                    </svg>
                                    <p>Belum ada transaksi kasir</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Informasi Tambahan -->
        <div class="rounded-2xl border border-[#FAD4C2] bg-gradient-to-br from-[#FFF8F3] to-white p-6 shadow-sm">
            <div class="flex items-start gap-4">
                <div class="rounded-full bg-[#C26A3D] p-3">
                    <svg class="h-6 w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <h4 class="text-lg font-semibold text-slate-900 mb-2">Tentang Laporan Kasir</h4>
                    <p class="text-sm text-slate-600 leading-relaxed mb-4">
                        Halaman ini menampilkan analisis lengkap transaksi kasir offline. Anda dapat melihat statistik harian, bulanan, performa kasir, dan produk terlaris yang dijual melalui kasir. Untuk mengakses sistem kasir POS, klik tombol "Buka Kasir POS" di bagian atas.
                    </p>
                    <div class="grid gap-3 sm:grid-cols-3 mt-4">
                        <div class="p-3 rounded-xl bg-white border border-[#FAD4C2]">
                            <p class="text-xs font-semibold text-slate-900 mb-1">Total Transaksi</p>
                            <p class="text-lg font-bold text-[#C26A3D]">{{ number_format($totalOfflineOrders) }}</p>
                        </div>
                        <div class="p-3 rounded-xl bg-white border border-[#FAD4C2]">
                            <p class="text-xs font-semibold text-slate-900 mb-1">Total Pendapatan</p>
                            <p class="text-lg font-bold text-green-600">Rp{{ number_format($totalOfflineRevenue, 0, ',', '.') }}</p>
                        </div>
                        <div class="p-3 rounded-xl bg-white border border-[#FAD4C2]">
                            <p class="text-xs font-semibold text-slate-900 mb-1">Akses Kasir</p>
                            <a href="{{ route('cashier.login') }}" target="_blank" class="text-xs font-semibold text-[#C26A3D] hover:underline">Login Kasir →</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
