<x-admin-layout>
    <x-slot name="pageTitle">Analisis Operasional</x-slot>
    <x-slot name="pageSubtitle">Pantau channel penjualan, top kategori, dan penggunaan produk aktif dalam satu layar.</x-slot>

    <div class="space-y-8">
        <div class="grid gap-6 md:grid-cols-2 xl:grid-cols-4">
            <x-admin.metric-card title="Total Pesanan" subtitle="Semua pesanan masuk" value="{{ number_format($totalOrders) }}" variant="primary" />
            <x-admin.metric-card title="Pendapatan Dibayar" subtitle="Hanya pesanan lunas" value="Rp {{ number_format($paidRevenue) }}" variant="success" />
            <x-admin.metric-card title="Kategori Aktif" subtitle="Kategori tampil" value="{{ number_format($activeCategories) }}" variant="warning" />
            <x-admin.metric-card title="Produk Aktif" subtitle="Produk aktif di katalog" value="{{ number_format($activeProducts) }}" variant="info" />
        </div>

        <div class="grid gap-6 lg:grid-cols-2">
            <section class="rounded-3xl border border-[#FAD4C2] bg-white p-5 shadow-sm shadow-[#FAD4C2]/30">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs font-semibold uppercase tracking-wide text-slate-500">Channel Online</p>
                        <h2 class="text-lg font-semibold text-slate-900">E-commerce store</h2>
                    </div>
                    <span class="text-xs text-slate-400">Share {{ $onlineOrderShare }}%</span>
                </div>
                <div class="mt-4 space-y-3">
                    <p class="text-sm text-slate-500">Pesanan tercatat</p>
                    <p class="text-3xl font-semibold text-slate-900">{{ number_format($onlineOrders) }}</p>
                    <p class="text-sm text-slate-500 flex items-center gap-2">
                        <span class="h-2 w-2 rounded-full bg-sky-500"></span> Revenue
                        <span class="font-semibold text-slate-800">Rp {{ number_format($onlineRevenue) }}</span>
                    </p>
                    <p class="text-xs text-slate-500">Revenue share {{ $onlineRevenueShare }}% dari total lunas</p>
                </div>
            </section>

            <section class="rounded-3xl border border-[#FAD4C2] bg-white p-5 shadow-sm shadow-[#FAD4C2]/30">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs font-semibold uppercase tracking-wide text-slate-500">Channel Kasir</p>
                        <h2 class="text-lg font-semibold text-slate-900">POS dan layanan offline</h2>
                    </div>
                    <span class="text-xs text-slate-400">Share {{ $offlineOrderShare }}%</span>
                </div>
                <div class="mt-4 space-y-3">
                    <p class="text-sm text-slate-500">Pesanan tercatat</p>
                    <p class="text-3xl font-semibold text-slate-900">{{ number_format($offlineOrders) }}</p>
                    <p class="text-sm text-slate-500 flex items-center gap-2">
                        <span class="h-2 w-2 rounded-full bg-orange-500"></span> Revenue
                        <span class="font-semibold text-slate-800">Rp {{ number_format($offlineRevenue) }}</span>
                    </p>
                    <p class="text-xs text-slate-500">Revenue share {{ $offlineRevenueShare }}% dari total lunas</p>
                </div>
            </section>
        </div>

        <div class="grid gap-6 lg:grid-cols-3">
            <section class="rounded-3xl border border-[#FAD4C2] bg-white p-5 shadow-sm shadow-[#FAD4C2]/30">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs font-semibold uppercase tracking-wide text-slate-500">Kategori</p>
                        <h2 class="text-lg font-semibold text-slate-900">Status Aktif vs Nonaktif</h2>
                    </div>
                    <span class="text-xs text-slate-400">Real-time</span>
                </div>
                <div class="mt-4 h-52">
                    <canvas id="categoryStatusChart"></canvas>
                </div>
            </section>

            <section class="rounded-3xl border border-[#FAD4C2] bg-white p-5 shadow-sm shadow-[#FAD4C2]/30">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs font-semibold uppercase tracking-wide text-slate-500">Channel</p>
                        <h2 class="text-lg font-semibold text-slate-900">Distribusi Pesanan</h2>
                    </div>
                    <span class="text-xs text-slate-400">Total {{ number_format($totalOrders) }} pesanan</span>
                </div>
                <div class="mt-4 h-52">
                    <canvas id="channelChart"></canvas>
                </div>
            </section>

            <section class="rounded-3xl border border-[#FAD4C2] bg-white p-5 shadow-sm shadow-[#FAD4C2]/30">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs font-semibold uppercase tracking-wide text-slate-500">Channel</p>
                        <h2 class="text-lg font-semibold text-slate-900">Revenue per Channel</h2>
                    </div>
                    <span class="text-xs text-slate-400">Pendapatan lunas</span>
                </div>
                <div class="mt-4 h-52">
                    <canvas id="channelRevenueChart"></canvas>
                </div>
            </section>

            <section class="rounded-3xl border border-[#FAD4C2] bg-white p-5 shadow-sm shadow-[#FAD4C2]/30">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-xs font-semibold uppercase tracking-wide text-slate-500">Produk</p>
                        <h2 class="text-lg font-semibold text-slate-900">Top Produk Terlaris</h2>
                    </div>
                    <span class="text-xs text-slate-400">Berdasarkan jumlah terjual</span>
                </div>
                <div class="mt-4 h-52">
                    <canvas id="topProductChart"></canvas>
                </div>
            </section>
        </div>

        <section class="rounded-3xl border border-[#FAD4C2]/70 bg-white p-6 shadow-sm shadow-[#FAD4C2]/30">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-base font-semibold text-slate-900">Detail Top Kategori</h3>
                    <p class="text-sm text-slate-500">Kategori dengan jumlah produk terbanyak</p>
                </div>
                <span class="text-xs text-slate-400">Terbatas 6 teratas</span>
            </div>
            <div class="mt-6 grid gap-4 md:grid-cols-2">
                @foreach ($topProducts as $product)
                    <article class="rounded-2xl border border-[#FAD4C2]/50 bg-[#FFF7F2] p-4">
                        <p class="text-xs font-semibold uppercase tracking-wider text-slate-500">#{{ $loop->iteration }}</p>
                        <p class="text-lg font-semibold text-slate-900">{{ $product->name }}</p>
                        <p class="text-sm text-slate-600">Terjual: {{ number_format($product->sold_quantity) }}</p>
                    </article>
                @endforeach
            </div>
        </section>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const statusCtx = document.getElementById('categoryStatusChart');
            const channelCtx = document.getElementById('channelChart');
            const revenueCtx = document.getElementById('channelRevenueChart');
            const topProductCtx = document.getElementById('topProductChart');

            const statusData = @json($statusChart);
            const channelData = @json($channelChart);
            const revenueData = @json($channelRevenueChart);
            const topProductData = @json($topProductChart);

            if (statusCtx && window.Chart) {
                new Chart(statusCtx, {
                    type: 'doughnut',
                    data: {
                        labels: statusData.labels,
                        datasets: [{
                            data: statusData.data,
                            backgroundColor: ['#34D399', '#F87171'],
                            borderWidth: 0,
                        }],
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: {
                                position: 'bottom',
                                labels: { color: '#475467', boxWidth: 12, padding: 12 },
                            },
                        },
                    },
                });
            }

            if (channelCtx && window.Chart) {
                new Chart(channelCtx, {
                    type: 'pie',
                    data: {
                        labels: channelData.labels,
                        datasets: [{
                            data: channelData.data,
                            backgroundColor: ['#2563EB', '#F97316', '#EF4444'],
                            borderWidth: 0,
                        }],
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: {
                                position: 'bottom',
                                labels: { color: '#475467', boxWidth: 12, padding: 12 },
                            },
                        },
                    },
                });
            }

            if (revenueCtx && window.Chart) {
                new Chart(revenueCtx, {
                    type: 'bar',
                    data: {
                        labels: revenueData.labels,
                        datasets: [{
                            label: 'Pendapatan',
                            data: revenueData.data,
                            backgroundColor: ['#2563EB', '#F97316'],
                            borderRadius: 6,
                            barPercentage: 0.6,
                        }],
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: { display: false },
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                grid: {
                                    borderDash: [3, 3],
                                    color: '#E5E7EB',
                                },
                                ticks: {
                                    color: '#475467',
                                },
                            },
                            x: {
                                ticks: {
                                    color: '#475467',
                                },
                                grid: { display: false },
                            },
                        },
                    },
                });
            }

            if (topProductCtx && window.Chart) {
                new Chart(topProductCtx, {
                    type: 'bar',
                    data: {
                        labels: topProductData.labels,
                        datasets: [{
                            label: 'Jumlah Produk',
                            data: topProductData.data,
                            backgroundColor: '#C26A3D',
                            borderRadius: 6,
                            barPercentage: 0.6,
                        }],
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: { display: false },
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                grid: {
                                    borderDash: [3, 3],
                                    color: '#E5E7EB',
                                },
                                ticks: {
                                    color: '#475467',
                                },
                            },
                            x: {
                                ticks: {
                                    color: '#475467',
                                },
                                grid: { display: false },
                            },
                        },
                    },
                });
            }
        });
    </script>
</x-admin-layout>
