<x-admin-layout>
    <x-slot name="pageTitle">Log Aktivitas</x-slot>
    <x-slot name="pageSubtitle">Riwayat tindakan penting oleh admin/kasir.</x-slot>

    <x-admin.card title="Filter">
        <form method="GET" class="mt-4 grid gap-4 md:grid-cols-[2fr,auto] items-end">
            <x-admin.input-field label="Cari route / path / method">
                <input type="text" name="search" value="{{ $search ?? '' }}" class="admin-input" />
            </x-admin.input-field>
            <button class="inline-flex items-center rounded-full bg-[#C26A3D] px-5 py-2 text-sm font-semibold text-white hover:bg-[#a85327]">Terapkan</button>
        </form>
    </x-admin.card>

    <x-admin.card title="Riwayat Aktivitas">
        <div class="mt-4 overflow-hidden rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-[#FAD4C2]/60 dark:divide-slate-800 text-sm">
                    <thead class="bg-[#FFF0E6] dark:bg-slate-800 text-left text-xs uppercase text-slate-500 dark:text-slate-400">
                        <tr>
                            <th class="px-4 py-3">Waktu</th>
                            <th class="px-4 py-3">User</th>
                            <th class="px-4 py-3">Method</th>
                            <th class="px-4 py-3">Route</th>
                            <th class="px-4 py-3">Path</th>
                            <th class="px-4 py-3">IP</th>
                            <th class="px-4 py-3">Payload</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-[#FAD4C2]/40 dark:divide-slate-800 bg-white dark:bg-slate-900">
                        @forelse($logs as $log)
                            <tr class="transition hover:bg-[#FFF7F2] dark:hover:bg-slate-800">
                                <td class="px-4 py-3">{{ $log->created_at->format('d M Y H:i:s') }}</td>
                                <td class="px-4 py-3">{{ $log->user?->name ?: '-' }}</td>
                                <td class="px-4 py-3 font-semibold">{{ $log->method }}</td>
                                <td class="px-4 py-3">{{ $log->route ?: '-' }}</td>
                                <td class="px-4 py-3">/{{ $log->path }}</td>
                                <td class="px-4 py-3 text-xs">{{ $log->ip }}</td>
                                <td class="px-4 py-3 text-xs">{{ implode(', ', (array) $log->payload_keys) }}</td>
                            </tr>
                        @empty
                            <tr><td colspan="7" class="px-4 py-8 text-center text-slate-500">Belum ada aktivitas.</td></tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        <div class="mt-4">{{ $logs->onEachSide(1)->links() }}</div>
    </x-admin.card>
</x-admin-layout>
