<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-semibold text-slate-900 dark:text-slate-100">Notifikasi</h1>
                <p class="text-sm text-slate-500 dark:text-slate-400">Status pesanan dan pemberitahuan penting.</p>
            </div>
            @if($unpaidCount > 0 || $pendingCount > 0)
                <div class="flex items-center gap-2">
                    @if($unpaidCount > 0)
                        <span class="inline-flex items-center gap-1.5 rounded-full bg-amber-100 dark:bg-amber-900/30 px-3 py-1 text-xs font-semibold text-amber-700 dark:text-amber-300">
                            <span class="h-2 w-2 rounded-full bg-amber-500 animate-pulse"></span>
                            {{ $unpaidCount }} Belum Bayar
                        </span>
                    @endif
                    @if($pendingCount > 0)
                        <span class="inline-flex items-center gap-1.5 rounded-full bg-blue-100 dark:bg-blue-900/30 px-3 py-1 text-xs font-semibold text-blue-700 dark:text-blue-300">
                            <span class="h-2 w-2 rounded-full bg-blue-500 animate-pulse"></span>
                            {{ $pendingCount }} Diproses
                        </span>
                    @endif
                </div>
            @endif
        </div>
    </x-slot>

    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        @if($notifications->isEmpty())
            <div class="rounded-3xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 p-12 text-center">
                <svg class="mx-auto h-16 w-16 text-slate-300 dark:text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                </svg>
                <h3 class="mt-4 text-lg font-semibold text-slate-900 dark:text-white">Tidak Ada Notifikasi</h3>
                <p class="mt-2 text-sm text-slate-500 dark:text-slate-400">Semua pesanan Anda dalam kondisi baik. Tidak ada yang memerlukan perhatian saat ini.</p>
                <a href="{{ route('products.index') }}" class="mt-6 inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-[#C26A3D] to-[#F5703B] px-6 py-2.5 text-sm font-semibold text-white shadow-md hover:shadow-lg transition">
                    <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                    </svg>
                    Mulai Belanja
                </a>
            </div>
        @else
            <div class="space-y-4">
                @foreach($notifications as $notification)
                    <div class="rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-white dark:bg-slate-900 p-4 hover:shadow-md transition">
                        <div class="flex items-start gap-4">
                            <div class="flex h-12 w-12 items-center justify-center rounded-xl 
                                @if($notification['color'] === 'amber') bg-amber-100 dark:bg-amber-900/30
                                @elseif($notification['color'] === 'blue') bg-blue-100 dark:bg-blue-900/30
                                @elseif($notification['color'] === 'green') bg-green-100 dark:bg-green-900/30
                                @else bg-slate-100 dark:bg-slate-800 @endif">
                                @if($notification['icon'] === 'credit-card')
                                    <svg class="h-6 w-6 @if($notification['color'] === 'amber') text-amber-600 dark:text-amber-400 @else text-slate-600 @endif" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                                    </svg>
                                @elseif($notification['icon'] === 'truck')
                                    <svg class="h-6 w-6 @if($notification['color'] === 'blue') text-blue-600 dark:text-blue-400 @else text-slate-600 @endif" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16V6a1 1 0 00-1-1H4a1 1 0 00-1 1v10a1 1 0 001 1h1m8-1a1 1 0 01-1 1H6m7-1V6h3l3 3v6a1 1 0 01-1 1h-1m-6 0a2 2 0 104 0m-4 0a2 2 0 114 0"></path>
                                    </svg>
                                @else
                                    <svg class="h-6 w-6 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                                    </svg>
                                @endif
                            </div>
                            <div class="flex-1 min-w-0">
                                <div class="flex items-start justify-between gap-2">
                                    <div>
                                        <h3 class="text-sm font-semibold text-slate-900 dark:text-white">{{ $notification['title'] }}</h3>
                                        <p class="mt-1 text-sm text-slate-600 dark:text-slate-400">{{ $notification['message'] }}</p>
                                    </div>
                                    <span class="text-xs text-slate-500 dark:text-slate-400 whitespace-nowrap">
                                        {{ $notification['created_at']->diffForHumans() }}
                                    </span>
                                </div>
                                <div class="mt-3 flex items-center gap-2">
                                    <a href="{{ route('orders.show', $notification['order']) }}" class="inline-flex items-center gap-1.5 rounded-lg border border-[#C26A3D] bg-white dark:bg-slate-800 px-3 py-1.5 text-xs font-semibold text-[#C26A3D] dark:text-amber-300 hover:bg-[#FFE2CF] dark:hover:bg-slate-700 transition">
                                        <svg class="h-3.5 w-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                        </svg>
                                        Lihat Detail
                                    </a>
                                    @if($notification['type'] === 'payment_required')
                                        <a href="{{ route('orders.payment', $notification['order']) }}" class="inline-flex items-center gap-1.5 rounded-lg bg-gradient-to-r from-[#C26A3D] to-[#F5703B] px-3 py-1.5 text-xs font-semibold text-white hover:shadow-md transition">
                                            <svg class="h-3.5 w-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                            </svg>
                                            Bayar Sekarang
                                        </a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</x-app-layout>
