<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-semibold text-slate-900 dark:text-slate-100">Alamat Pengiriman</h1>
                <p class="text-sm text-slate-500 dark:text-slate-400">Simpan beberapa alamat tujuan untuk checkout lebih cepat.</p>
            </div>
        </div>
    </x-slot>

    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 py-8 space-y-8">
        <div class="rounded-3xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 p-6">
            <h2 class="text-lg font-semibold text-slate-900 dark:text-slate-100 mb-4">Tambah Alamat</h2>
            <form action="{{ route('account.addresses.store') }}" method="POST" class="grid gap-4 md:grid-cols-2">
                @csrf
                <input type="text" name="label" placeholder="Label (Rumah/Kantor)" class="admin-input">
                <input type="text" name="recipient_name" placeholder="Nama penerima" required class="admin-input">
                <input type="text" name="phone" placeholder="No. HP" required class="admin-input">
                <input type="text" name="postal_code" placeholder="Kode Pos" required class="admin-input">
                <input type="text" name="address_line1" placeholder="Alamat" required class="admin-input md:col-span-2">
                <input type="text" name="address_line2" placeholder="Detail (opsional)" class="admin-input md:col-span-2">
                <input type="text" name="district" placeholder="Kecamatan" class="admin-input">
                <input type="text" name="village" placeholder="Kelurahan" class="admin-input">
                <input type="text" name="city" placeholder="Kota/Kabupaten" required class="admin-input">
                <input type="text" name="province" placeholder="Provinsi" required class="admin-input">
                <label class="inline-flex items-center gap-2 text-sm text-slate-600 dark:text-slate-300 md:col-span-2">
                    <input type="checkbox" name="is_default" value="1" class="rounded border-slate-300 text-[#C26A3D] focus:ring-[#C26A3D]"> Jadikan alamat utama
                </label>
                <div class="md:col-span-2 flex justify-end">
                    <button class="inline-flex items-center rounded-full bg-[#C26A3D] px-5 py-2 text-sm font-semibold text-white hover:bg-[#a85327]">Simpan Alamat</button>
                </div>
            </form>
        </div>

        <div class="rounded-3xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 p-6">
            <h2 class="text-lg font-semibold text-slate-900 dark:text-slate-100 mb-4">Daftar Alamat</h2>
            <div class="grid gap-4 md:grid-cols-2">
                @forelse ($addresses as $address)
                    <div class="rounded-2xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 p-4">
                        <div class="flex items-start justify-between">
                            <div class="space-y-1 text-sm">
                                <p class="font-semibold text-slate-900 dark:text-slate-100">{{ $address->label ?: 'Alamat' }} @if($address->is_default)<span class="ml-2 rounded-full bg-emerald-100 text-emerald-700 px-2 py-0.5 text-[11px] font-semibold">Utama</span>@endif</p>
                                <p class="text-slate-600 dark:text-slate-300">{{ $address->recipient_name }} • {{ $address->phone }}</p>
                                <p class="text-slate-600 dark:text-slate-300">{{ $address->address_line1 }} {{ $address->address_line2 }}</p>
                                <p class="text-slate-600 dark:text-slate-300">{{ $address->district }}, {{ $address->city }}, {{ $address->province }} {{ $address->postal_code }}</p>
                            </div>
                            <form action="{{ route('account.addresses.destroy', $address) }}" method="POST" onsubmit="return confirm('Hapus alamat ini?');">
                                @csrf
                                @method('DELETE')
                                <button class="inline-flex items-center rounded-full border border-rose-300 px-3 py-1 text-xs font-semibold text-rose-600 hover:bg-rose-50">
                                    <x-icon name="trash" class="h-4 w-4" />
                                </button>
                            </form>
                        </div>
                        <form method="POST" action="{{ route('account.addresses.update', $address) }}" class="mt-3 grid gap-2">
                            @csrf
                            @method('PATCH')
                            <div class="grid gap-2 md:grid-cols-2">
                                <input type="text" name="recipient_name" value="{{ $address->recipient_name }}" class="admin-input" />
                                <input type="text" name="phone" value="{{ $address->phone }}" class="admin-input" />
                                <input type="text" name="address_line1" value="{{ $address->address_line1 }}" class="admin-input md:col-span-2" />
                                <input type="text" name="address_line2" value="{{ $address->address_line2 }}" class="admin-input md:col-span-2" />
                            </div>
                            <label class="inline-flex items-center gap-2 text-sm text-slate-600 dark:text-slate-300">
                                <input type="checkbox" name="is_default" value="1" class="rounded border-slate-300 text-[#C26A3D] focus:ring-[#C26A3D]" @checked($address->is_default) /> Jadikan alamat utama
                            </label>
                            <div class="flex justify-end">
                                <button class="inline-flex items-center rounded-full border border-[#C26A3D] px-4 py-2 text-xs font-semibold text-[#C26A3D] hover:bg-[#FFE2CF]">Perbarui</button>
                            </div>
                        </form>
                    </div>
                @empty
                    <p class="text-sm text-slate-500">Belum ada alamat.</p>
                @endforelse
            </div>
        </div>
    </div>
</x-app-layout>

