<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\Product;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class UpdateCategoriesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Produk Kecantikan',
                'slug' => 'produk-kecantikan',
                'tagline' => 'Produk kecantikan terlengkap untuk tampil percaya diri setiap hari',
                'description' => 'Perawatan kulit, makeup, dan body care berkualitas untuk rutinitas harian.',
                'hero_image' => 'Dshop banner/Produk kecantikan rvs.png',
                'carousel_image' => 'Dshop banner/Produk kecantikan rvs.png',
            ],
            [
                'name' => 'Fashion',
                'slug' => 'fashion',
                'tagline' => 'Koleksi fashion trendy dan stylish untuk gaya hidup modern Anda',
                'description' => 'Outfit kasual hingga formal dengan gaya yang selalu up-to-date.',
                'hero_image' => 'Dshop banner/Fashion new.png',
                'carousel_image' => 'Dshop banner/Fashion new.png',
            ],
            [
                'name' => 'Mainan Anak',
                'slug' => 'mainan-anak',
                'tagline' => 'Mainan edukatif dan menyenangkan untuk tumbuh kembang si kecil',
                'description' => 'Mainan edukatif, kreatif, dan aman untuk mendukung perkembangan anak.',
                'hero_image' => 'Dshop banner/Mainan.png',
                'carousel_image' => 'Dshop banner/Mainan.png',
            ],
            [
                'name' => 'Produk Rumah Tangga',
                'slug' => 'produk-rumah-tangga',
                'tagline' => 'Perlengkapan rumah tangga berkualitas untuk kenyamanan keluarga',
                'description' => 'Peralatan rumah tangga fungsional untuk mendukung aktivitas harian.',
                'hero_image' => 'Dshop banner/PRODUK RUMAH TANGGA.png',
                'carousel_image' => 'Dshop banner/PRODUK RUMAH TANGGA.png',
            ],
            [
                'name' => 'Elektronik',
                'slug' => 'elektronik',
                'tagline' => 'Gadget dan elektronik terkini dengan teknologi canggih',
                'description' => 'Perangkat elektronik, gadget, dan aksesori untuk kebutuhan digital Anda.',
                'hero_image' => 'Dshop banner/elektronik.png',
                'carousel_image' => 'Dshop banner/elektronik.png',
            ],
            [
                'name' => 'Alat Tulis',
                'slug' => 'alat-tulis',
                'tagline' => 'Perlengkapan alat tulis lengkap untuk sekolah dan kantor',
                'description' => 'Alat tulis kantor dan sekolah yang lengkap, rapi, dan siap pakai.',
                'hero_image' => 'Dshop banner/ATK revisi no diskon.png',
                'carousel_image' => 'Dshop banner/ATK revisi no diskon.png',
            ],
        ];

        Category::where('slug', 'kacamata-fashion')
            ->orWhere('name', 'like', '%kacamata%')
            ->update(['is_active' => false]);

        foreach ($categories as $index => $categoryData) {
            $slug = $categoryData['slug'] ?? Str::slug($categoryData['name']);

             Category::updateOrCreate(
                 ['slug' => $slug],
                 [
                     'name' => $categoryData['name'],
                     'slug' => $slug,
                     'tagline' => $categoryData['tagline'] ?? null,
                     'description' => $categoryData['description'] ?? null,
                     'hero_image_url' => $categoryData['hero_image'],
                     'carousel_image_url' => $categoryData['carousel_image'] ?? $categoryData['hero_image'],
                 ]
             );
        }

        $kacamata = Category::where('slug', 'kacamata-fashion')
            ->orWhere('name', 'like', '%kacamata%')
            ->first();

        if ($kacamata) {
            $fallbackCategory = Category::where('slug', 'fashion')->first() ?? Category::first();

            if ($fallbackCategory && $fallbackCategory->id !== $kacamata->id) {
                Product::withTrashed()
                    ->where('category_id', $kacamata->id)
                    ->update(['category_id' => $fallbackCategory->id]);
            }

            $kacamata->delete();
        }

        $this->command->info('Kategori berhasil diupdate dengan gambar baru.');
        $this->command->info('Total: ' . count($categories) . ' kategori (kategori kacamata dinonaktifkan).');
    }
}
