<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\StoreSetting;
use App\Models\User;
use App\Models\UserAddress;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $admin = User::updateOrCreate(
            ['email' => 'admin@dshop.test'],
            [
                'name' => 'D\'Shop Owner',
                'role' => 'admin',
                'password' => Hash::make('password123'),
                'phone' => '6283879865012',
                'whatsapp_number' => '6283879865012',
                'email_verified_at' => now(),
            ]
        );

        $cashier = User::updateOrCreate(
            ['email' => 'kasir@dshop.test'],
            [
                'name' => 'D\'Shop Kasir',
                'role' => 'cashier',
                'password' => Hash::make('password123'),
                'email_verified_at' => now(),
            ]
        );

        $customer = User::updateOrCreate(
            ['email' => 'pelanggan@dshop.test'],
            [
                'name' => 'D\'Shop Customer',
                'role' => 'user',
                'password' => Hash::make('password123'),
                'whatsapp_number' => '6281234567890',
                'email_verified_at' => now(),
            ]
        );

        if (! $customer->addresses()->where('label', 'Rumah Utama')->exists()) {
            UserAddress::factory()->for($customer)->create([
                'label' => 'Rumah Utama',
                'recipient_name' => $customer->name,
                'phone' => $customer->whatsapp_number ?? '6281234567890',
                'address_line1' => 'Kp. Rancawiru RT.007/004 Ds. Kemuning, Kec. Kresek',
                'is_default' => true,
                'city' => 'Kabupaten Tangerang',
                'province' => 'Banten',
                'postal_code' => '15620',
            ]);
        }

        $categorySeed = [
            [
                'name' => 'Produk Kecantikan',
                'slug' => 'produk-kecantikan',
                'tagline' => 'Produk kecantikan terlengkap untuk tampil percaya diri setiap hari',
                'description' => 'Perawatan kulit, makeup, dan body care berkualitas untuk rutinitas harian.',
                'hero_image' => 'Dshop banner/Produk kecantikan rvs.png',
                'carousel_image' => 'Dshop banner/Produk kecantikan rvs.png',
            ],
            [
                'name' => 'Fashion',
                'slug' => 'fashion',
                'tagline' => 'Koleksi fashion trendy dan stylish untuk gaya hidup modern Anda',
                'description' => 'Outfit kasual hingga formal dengan gaya yang selalu up-to-date.',
                'hero_image' => 'Dshop banner/Fashion new.png',
                'carousel_image' => 'Dshop banner/Fashion new.png',
            ],
            [
                'name' => 'Mainan Anak',
                'slug' => 'mainan-anak',
                'tagline' => 'Mainan edukatif dan menyenangkan untuk tumbuh kembang si kecil',
                'description' => 'Mainan edukatif, kreatif, dan aman untuk mendukung perkembangan anak.',
                'hero_image' => 'Dshop banner/Mainan.png',
                'carousel_image' => 'Dshop banner/Mainan.png',
            ],
            [
                'name' => 'Produk Rumah Tangga',
                'slug' => 'produk-rumah-tangga',
                'tagline' => 'Perlengkapan rumah tangga berkualitas untuk kenyamanan keluarga',
                'description' => 'Peralatan rumah tangga fungsional untuk mendukung aktivitas harian.',
                'hero_image' => 'Dshop banner/PRODUK RUMAH TANGGA.png',
                'carousel_image' => 'Dshop banner/PRODUK RUMAH TANGGA.png',
            ],
            [
                'name' => 'Elektronik',
                'slug' => 'elektronik',
                'tagline' => 'Gadget dan elektronik terkini dengan teknologi canggih',
                'description' => 'Perangkat elektronik, gadget, dan aksesori untuk kebutuhan digital Anda.',
                'hero_image' => 'Dshop banner/elektronik.png',
                'carousel_image' => 'Dshop banner/elektronik.png',
            ],
            [
                'name' => 'Alat Tulis',
                'slug' => 'alat-tulis',
                'tagline' => 'Perlengkapan alat tulis lengkap untuk sekolah dan kantor',
                'description' => 'Alat tulis kantor dan sekolah yang lengkap, rapi, dan siap pakai.',
                'hero_image' => 'Dshop banner/ATK revisi no diskon.png',
                'carousel_image' => 'Dshop banner/ATK revisi no diskon.png',
            ],
        ];

        Category::where('slug', 'kacamata-fashion')
            ->orWhere('name', 'like', '%kacamata%')
            ->update(['is_active' => false]);

        $categories = collect($categorySeed)->map(function (array $data, int $index) {
            $slug = $data['slug'] ?? Str::slug($data['name']);

            return Category::updateOrCreate(
                ['slug' => $slug],
                [
                    'name' => $data['name'],
                    'slug' => $slug,
                    'tagline' => $data['tagline'],
                    'description' => $data['description'],
                    'hero_image' => $data['hero_image'],
                    'carousel_image' => $data['carousel_image'],
                    'display_order' => $index + 1,
                    'is_active' => true,
                ]
            );
        });

        Category::where('slug', 'kacamata-fashion')
            ->orWhere('name', 'like', '%kacamata%')
            ->delete();

        StoreSetting::updateOrCreate(
            ['key' => 'store.name'],
            ['group' => 'branding', 'value' => 'D\'Shop Official Store', 'type' => 'string', 'is_public' => true]
        );

        StoreSetting::updateOrCreate(
            ['key' => 'store.tagline'],
            ['group' => 'branding', 'value' => 'Temukan pilihan terbaik untuk gaya dan kebutuhan Anda.', 'type' => 'string', 'is_public' => true]
        );

        StoreSetting::updateOrCreate(
            ['key' => 'store.whatsapp_admin'],
            ['group' => 'contact', 'value' => '6283879865012', 'type' => 'string', 'is_public' => true]
        );

        StoreSetting::updateOrCreate(
            ['key' => 'store.brand_color'],
            ['group' => 'branding', 'value' => '#F7BFA0', 'type' => 'string', 'is_public' => true]
        );

        StoreSetting::updateOrCreate(
            ['key' => 'store.payment_policy'],
            ['group' => 'policy', 'value' => 'Pembayaran ditanggung pembeli. Ekspedisi JNE/JNT/Anteraja.', 'type' => 'string', 'is_public' => true]
        );
    }
}
