<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Category>
 */
class CategoryFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $name = $this->faker->unique()->words(2, true);

        return [
            'name' => ucwords($name),
            'slug' => \Str::slug($name),
            'tagline' => $this->faker->sentence(),
            'description' => $this->faker->paragraph(),
            'hero_image' => null,
            'carousel_image' => null,
            'display_order' => $this->faker->numberBetween(1, 10),
            'is_active' => true,
        ];
    }
}
