<?php

use App\Http\Middleware\ActivityLogMiddleware;
use App\Http\Middleware\RoleMiddleware;
use App\Http\Middleware\SwitchSessionCookie;
use App\Http\Middleware\Authenticate;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->alias([
            'auth' => Authenticate::class,
            'role' => RoleMiddleware::class,
            'activity.log' => ActivityLogMiddleware::class,
        ]);

        // Pastikan setiap prefix punya cookie sesi sendiri (admin/kasir/user)
        $middleware->prependToGroup('web', SwitchSessionCookie::class);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
