<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CartItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'cart_id',
        'product_id',
        'quantity',
        'unit_price',
        'subtotal',
        'is_selected',
    ];

    protected $casts = [
        'is_selected' => 'boolean',
    ];

    protected static function booted(): void
    {
        static::saving(function (CartItem $item) {
            $item->subtotal = $item->quantity * $item->unit_price;
        });

        static::saved(function (CartItem $item) {
            $item->cart?->refreshTotals();
        });

        static::deleted(function (CartItem $item) {
            $item->cart?->refreshTotals();
        });
    }

    public function cart()
    {
        return $this->belongsTo(Cart::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
