<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Cart extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'session_id',
        'status',
        'total_items',
        'total_amount',
        'notes',
        'expires_at',
        'last_activity_at',
    ];

    protected $casts = [
        'expires_at' => 'datetime',
        'last_activity_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function items(): HasMany
    {
        return $this->hasMany(CartItem::class);
    }

    public function selectedItems(): HasMany
    {
        return $this->items()->where('is_selected', true);
    }

    public function refreshTotals(): void
    {
        $this->total_items = $this->items()->sum('quantity');
        $this->total_amount = $this->items()->sum('subtotal');
        $this->last_activity_at = now();
        $this->save();
    }
}
