<?php

namespace App\Mail;

use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class PaymentSuccessNotification extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public Order $order
    ) {}

    public function envelope(): Envelope
    {
        $storeName = \App\Models\StoreSetting::getValue('store.name', config('app.name', "D'Shop"));
        
        return new Envelope(
            subject: "🎉 Pembayaran Berhasil - {$this->order->invoice_number}",
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.payment-success',
            with: [
                'order' => $this->order,
                'storeName' => \App\Models\StoreSetting::getValue('store.name', config('app.name', "D'Shop")),
                'storeTagline' => \App\Models\StoreSetting::getValue('store.tagline', 'Solusi UMKM Profesional.'),
            ],
        );
    }

    public function attachments(): array
    {
        return [];
    }
}





