<?php

namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;
use Illuminate\Http\Request;

class Authenticate extends Middleware
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     */
    protected function redirectTo(Request $request): ?string
    {
        if (! $request->expectsJson()) {
            $path = '/' . ltrim($request->path(), '/');

            if (str_starts_with($path, '/admin')) {
                return route('admin.login');
            }

            if (str_starts_with($path, '/kasir')) {
                return route('cashier.login');
            }

            return route('login');
        }

        return null;
    }
}
