<?php

namespace App\Http\Middleware;

use App\Models\ActivityLog;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ActivityLogMiddleware
{
    public function handle(Request $request, Closure $next): Response
    {
        $response = $next($request);

        try {
            if (! in_array($request->method(), ['GET', 'HEAD'])) {
                ActivityLog::create([
                    'user_id' => optional($request->user())->id,
                    'method' => $request->method(),
                    'route' => optional($request->route())->getName(),
                    'path' => $request->path(),
                    'action' => 'request',
                    'ip' => $request->ip(),
                    'user_agent' => (string) $request->userAgent(),
                    'payload_keys' => array_keys($request->except(['password', 'password_confirmation', '_token'])),
                ]);
            }
        } catch (\Throwable $e) {
            // Silently ignore logging errors
        }

        return $response;
    }
}

