<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Product;
use App\Models\StoreSetting;
use Illuminate\Http\Request;

class LandingController extends Controller
{
    public function __invoke(Request $request)
    {
        $categories = Category::active()
            ->with(['featuredProducts' => fn ($query) => $query->with('images')->limit(6)])
            ->orderBy('display_order')
            ->get();

        $newArrivals = Product::active()
            ->latest()
            ->with('category')
            ->take(8)
            ->get();

        $brandName = StoreSetting::getValue('store.name', config('app.name'));
        $brandTagline = StoreSetting::getValue('store.tagline', 'Belanja lengkap untuk kebutuhan gaya dan usaha Anda.');
        $adminWhatsapp = StoreSetting::getValue('store.whatsapp_admin', '6283879865012');
        $brandColor = StoreSetting::getValue('store.brand_color', '#F7BFA0');

        // Prepare banners
        $bannerPath = function($filename) {
            $publicPath = public_path('Dshop banner/' . $filename);
            if (file_exists($publicPath)) {
                return asset('Dshop banner/' . $filename);
            }
            // Fallback ke folder asli jika belum di-copy
            $originalPath = base_path('Dshop banner/' . $filename);
            if (file_exists($originalPath)) {
                // Copy ke public folder untuk akses web
                $targetDir = public_path('Dshop banner');
                if (!file_exists($targetDir)) {
                    mkdir($targetDir, 0755, true);
                }
                copy($originalPath, $publicPath);
                return asset('Dshop banner/' . $filename);
            }
            // Placeholder jika tidak ada
            return 'https://via.placeholder.com/1200x600?text=' . urlencode($filename);
        };

        $banners = [
            [
                'image' => $bannerPath('BANNER.jpg'),
                'title' => 'D\'Shop Online',
                'subtitle' => 'Toko Online Terpercaya untuk Kebutuhan Fashion, Kecantikan & Lifestyle Anda',
                'link' => route('products.index'),
                'button_text' => 'Jelajahi Katalog'
            ],
            [
                'image' => $bannerPath('Fashion new.png'),
                'title' => 'Koleksi Fashion Terbaru',
                'subtitle' => 'Temukan gaya terbaru untuk penampilan yang lebih menarik dan stylish',
                'link' => route('products.index', ['category' => 'fashion']),
                'button_text' => 'Lihat Fashion'
            ],
            [
                'image' => $bannerPath('Produk kecantikan rvs.png'),
                'title' => 'Produk Kecantikan Premium',
                'subtitle' => 'Rawat kecantikan Anda dengan produk berkualitas tinggi dan terpercaya',
                'link' => route('products.index', ['category' => 'produk-kecantikan']),
                'button_text' => 'Lihat Kecantikan'
            ],
            [
                'image' => $bannerPath('elektronik.png'),
                'title' => 'Elektronik & Gadget Unggulan',
                'subtitle' => 'Perangkat terkini untuk mendukung produktivitas dan hiburan Anda',
                'link' => route('products.index', ['category' => 'elektronik']),
                'button_text' => 'Lihat Elektronik'
            ],
        ];

        return view('landing.index', [
            'categories' => $categories,
            'newArrivals' => $newArrivals,
            'brandName' => $brandName,
            'brandTagline' => $brandTagline,
            'brandColor' => $brandColor,
            'adminWhatsapp' => $adminWhatsapp,
            'banners' => $banners,
        ]);
    }
}
