<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use App\Enums\UserRole;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;

class CashierLoginController extends Controller
{
    /**
     * Display the cashier login view.
     */
    public function create(): View
    {
        return view('auth.cashier-login');
    }

    /**
     * Handle an incoming authentication request for cashier.
     */
    public function store(LoginRequest $request): RedirectResponse
    {
        $request->authenticate('cashier');

        $user = Auth::guard('cashier')->user();

        // Cek apakah user adalah kasir atau admin
        if (!in_array($user->role, [UserRole::Cashier, UserRole::Admin])) {
            Auth::guard('cashier')->logout();
            return back()->withErrors([
                'email' => 'Anda tidak memiliki akses ke halaman kasir.',
            ])->withInput($request->only('email'));
        }

        $request->session()->regenerate();

        return redirect()->intended(route('cashier.dashboard', absolute: false))->with('status', 'Login berhasil!');
    }
}
