<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\StoreSetting;
use Illuminate\Http\Request;
use Illuminate\View\View;

class AdminShippingController extends Controller
{
    public function index(): View
    {
        $enabledCouriers = (array) (StoreSetting::getValue('shipping.couriers', ['jne' => true, 'pos' => true, 'cod' => false, 'internal' => false]) ?? []);
        $originCity = (string) (StoreSetting::getValue('shipping.origin_city', '') ?? '');
        $rajaKey = (string) (StoreSetting::getValue('shipping.rajaongkir_key', '') ?? '');

        return view('admin.shipping.index', [
            'enabledCouriers' => $enabledCouriers,
            'originCity' => $originCity,
            'rajaKey' => $rajaKey,
        ]);
    }

    public function update(Request $request)
    {
        $data = $request->validate([
            'couriers' => ['array'],
            'origin_city' => ['nullable', 'string', 'max:120'],
            'rajaongkir_key' => ['nullable', 'string', 'max:200'],
        ]);

        $couriers = [
            'jne' => $request->boolean('couriers.jne'),
            'pos' => $request->boolean('couriers.pos'),
            'cod' => $request->boolean('couriers.cod'),
            'internal' => $request->boolean('couriers.internal'),
        ];

        StoreSetting::updateOrCreate(['key' => 'shipping.couriers'], ['value' => json_encode($couriers), 'type' => 'json']);
        StoreSetting::updateOrCreate(['key' => 'shipping.origin_city'], ['value' => (string) ($data['origin_city'] ?? '')]);
        if (array_key_exists('rajaongkir_key', $data)) {
            StoreSetting::updateOrCreate(['key' => 'shipping.rajaongkir_key'], ['value' => (string) $data['rajaongkir_key']]);
        }

        cache()->forget('store_setting_shipping.couriers');
        cache()->forget('store_setting_shipping.origin_city');
        cache()->forget('store_setting_shipping.rajaongkir_key');

        return back()->with('status', 'Pengaturan pengiriman tersimpan.');
    }
}

