<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Payment;
use Illuminate\Http\Request;
use Illuminate\View\View;

class AdminPaymentController extends Controller
{
    public function index(Request $request): View
    {
        $filters = [
            'method' => (string) $request->input('method', ''),
            'status' => (string) $request->input('status', ''),
            'search' => (string) $request->input('search', ''),
        ];

        $payments = Payment::query()
            ->when($filters['method'], fn($q) => $q->where('method', $filters['method']))
            ->when($filters['status'], fn($q) => $q->where('status', $filters['status']))
            ->when($filters['search'], function ($q) use ($filters) {
                $term = $filters['search'];
                $q->where(function ($qq) use ($term) {
                    $qq->where('reference', 'like', "%{$term}%")
                       ->orWhere('virtual_account', 'like', "%{$term}%");
                });
            })
            ->with('order')
            ->latest('id')
            ->paginate(15)
            ->withQueryString();

        return view('admin.payments.index', [
            'payments' => $payments,
            'filters' => $filters,
        ]);
    }
}

