<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ActivityLog;
use Illuminate\Http\Request;
use Illuminate\View\View;

class AdminActivityLogController extends Controller
{
    public function index(Request $request): View
    {
        $search = (string) $request->input('search', '');
        $logs = ActivityLog::query()
            ->with('user')
            ->when($search, function ($q) use ($search) {
                $q->where('route', 'like', "%{$search}%")
                  ->orWhere('path', 'like', "%{$search}%")
                  ->orWhere('method', 'like', "%{$search}%");
            })
            ->latest()
            ->paginate(20)
            ->withQueryString();

        return view('admin.activity.index', [
            'logs' => $logs,
            'search' => $search,
        ]);
    }
}
