<?php

namespace App\Exports;

use App\Models\Order;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class IncomeExport implements FromView, ShouldAutoSize
{
    public function __construct(
        protected Collection $orders,
        protected string $periodLabel = ''
    ) {
    }

    public function view(): View
    {
        return view('exports.income', [
            'orders' => $this->orders,
            'periodLabel' => $this->periodLabel,
            'generatedAt' => now(),
            'totalIncome' => $this->orders->sum(fn (Order $order) => $order->net_income),
        ]);
    }
}

