# 🚀 SETUP KOMERCE API UNTUK ONGKIR OTOMATIS

## ✅ Anda Sudah Punya Akun Komerce! (Lebih Mudah dari RajaOngkir)

---

## 📋 **LANGKAH-LANGKAH SETUP:**

### **Langkah 1: Ambil API Key "Shipping Cost"**

1. Di halaman Komerce yang sedang terbuka
2. Klik **"Show Key"** pada baris **"Shipping Cost"** (nomor 1)
3. Copy API key yang muncul

---

### **Langkah 2: Buka File .env**

Buka file: `C:\xampp\htdocs\web\dshop\.env`

(Gunakan Notepad atau text editor)

---

### **Langkah 3: Tambahkan Konfigurasi**

**Cari baris yang ada `RAJAONGKIR_` (jika ada), atau tambahkan di bagian bawah:**

```env
# ============================================
# KOMERCE API CONFIGURATION (untuk Ongkir)
# ============================================

# Paste API key "Shipping Cost" dari Komerce
RAJAONGKIR_API_KEY=paste_api_key_shipping_cost_disini

# Untuk Komerce, gunakan base_url khusus
RAJAONGKIR_BASE_URL=https://collaborator.komerce.id/rajaongkir

# Account type (tidak dipakai untuk Komerce, tapi tetap isi)
RAJAONGKIR_ACCOUNT_TYPE=starter

# Origin City ID untuk Kabupaten Tangerang
RAJAONGKIR_ORIGIN_CITY_ID=455

```

---

### **Langkah 4: Contoh Lengkap**

Misalnya API key Anda adalah: `abc123xyz789`

Maka isi di `.env` seperti ini:

```env
RAJAONGKIR_API_KEY=abc123xyz789
RAJAONGKIR_BASE_URL=https://collaborator.komerce.id/rajaongkir
RAJAONGKIR_ACCOUNT_TYPE=starter
RAJAONGKIR_ORIGIN_CITY_ID=455
```

**IMPORTANT:** 
- ❌ Jangan ada spasi sebelum/sesudah tanda `=`
- ❌ Jangan pakai tanda kutip (`"` atau `'`)
- ✅ Copy paste API key yang asli dari Komerce

---

### **Langkah 5: Clear Cache Laravel**

Buka **Command Prompt** atau **Terminal**, lalu:

```bash
cd C:\xampp\htdocs\web\dshop
php artisan config:clear
php artisan cache:clear
```

**Output yang diharapkan:**
```
Configuration cache cleared successfully.
Application cache cleared successfully.
```

---

### **Langkah 6: Test API**

Jalankan test script:

```bash
php test-rajaongkir.php
```

**Output yang HARUS muncul:**
```
✅ PASSED: API Key configured
✅ PASSED: Service is configured
✅ PASSED: Retrieved 34 provinces
✅ PASSED: Retrieved 501 cities
✅ 'tangerang': Found 3 result(s)
   - Kabupaten Tangerang (ID: 455)
   - Kota Tangerang (ID: 456)
   - Kota Tangerang Selatan (ID: 457)
```

---

### **Langkah 7: Test di Browser**

1. **Buka browser**
2. **Refresh halaman checkout** (atau buka: `http://127.0.0.1:8000/checkout`)
3. **Ketik "tangerang"** di field Kota/Kabupaten
4. **Harus muncul dropdown:**
   ```
   📍 Kabupaten Tangerang
      Banten
   📍 Kota Tangerang
      Banten
   📍 Kota Tangerang Selatan
      Banten
   ```

5. **Pilih "Kabupaten Tangerang"**
6. **Klik "Cek Ongkir"**
7. **Harus muncul opsi kurir** (JNE, POS, TIKI, dll)

---

## 🎯 **KENAPA PILIH "Shipping Cost"?**

| API | Fungsi | Untuk Apa |
|-----|--------|-----------|
| **Shipping Cost** ✅ | Calculate ongkir | **CEK ONGKIR DI CHECKOUT** ← Ini yang dibutuhkan! |
| Shipping Delivery | Tracking & status | Update status pengiriman (optional) |

---

## 📍 **City ID untuk Kabupaten Tangerang**

Setelah API aktif, cek lokasi toko Anda:

```bash
php artisan tinker
```

Lalu ketik:

```php
$service = app(App\Services\Shipping\RajaOngkirService::class);
$results = $service->searchCity('tangerang');
foreach($results as $city) {
    echo "{$city['type']} {$city['city_name']} - ID: {$city['city_id']}\n";
}
exit
```

**Akan muncul:**
```
Kabupaten Tangerang - ID: 455
Kota Tangerang - ID: 456
Kota Tangerang Selatan - ID: 457
```

**Pilih yang sesuai lokasi toko:**

- **ID 455** = Kabupaten Tangerang (Serpong lama, Balaraja, Cikupa, Kelapa Dua, dll)
- **ID 456** = Kota Tangerang (Ciledug, Karawaci, Gading Serpong, dll)
- **ID 457** = Kota Tangerang Selatan (BSD, Pondok Aren, Pamulang, Bintaro, dll)

Jika perlu ganti, edit `.env`:
```env
RAJAONGKIR_ORIGIN_CITY_ID=456  # ganti angka sesuai kebutuhan
```

Lalu:
```bash
php artisan config:clear
```

---

## ✅ **CHECKLIST SETUP:**

- [ ] Klik "Show Key" di Komerce untuk "Shipping Cost"
- [ ] Copy API key
- [ ] Buka file `.env`
- [ ] Tambahkan konfigurasi (4 baris)
- [ ] Save file `.env`
- [ ] Jalankan: `php artisan config:clear`
- [ ] Jalankan: `php artisan cache:clear`
- [ ] Test: `php test-rajaongkir.php`
- [ ] Refresh browser & test ketik "tangerang"
- [ ] Klik "Cek Ongkir" untuk test hitung ongkir

---

## 🐛 **Troubleshooting:**

### **Problem: "No cities retrieved"**

**Solusi:**
1. Pastikan API key benar (tidak ada typo)
2. Pastikan tidak ada spasi di `.env`
3. Clear cache lagi:
   ```bash
   php artisan config:clear
   php artisan cache:clear
   ```

---

### **Problem: "Kota tidak ditemukan" setelah ketik**

**Solusi:**
1. Cek apakah `RAJAONGKIR_BASE_URL` sudah benar
2. Pastikan:
   ```env
   RAJAONGKIR_BASE_URL=https://collaborator.komerce.id/rajaongkir
   ```
3. Clear cache

---

### **Problem: Browser masih tidak muncul hasil**

**Solusi:**
1. Hard refresh browser: **Ctrl + Shift + R**
2. Clear browser cache
3. Buka Incognito/Private mode
4. Cek browser console (F12) untuk error

---

## 🎉 **KEUNTUNGAN PAKAI KOMERCE API:**

- ✅ Anda sudah punya akun (tidak perlu daftar baru)
- ✅ Gratis 100 requests/hari (cukup untuk testing)
- ✅ Interface sama dengan RajaOngkir (compatible)
- ✅ Bisa cek ongkir real-time
- ✅ Customer bisa pilih kurir sendiri

---

## 📞 **Need Help?**

Jika ada error setelah setup:

1. **Cek logs:**
   ```
   storage/logs/laravel.log
   ```

2. **Re-test:**
   ```bash
   php test-rajaongkir.php
   ```

3. **Cek browser console:**
   - Tekan F12
   - Tab "Console"
   - Lihat error merah

---

## 🚀 **Quick Summary:**

```bash
# 1. Copy API key "Shipping Cost" dari Komerce

# 2. Edit .env, tambahkan:
RAJAONGKIR_API_KEY=your_komerce_api_key_here
RAJAONGKIR_BASE_URL=https://collaborator.komerce.id/rajaongkir
RAJAONGKIR_ACCOUNT_TYPE=starter
RAJAONGKIR_ORIGIN_CITY_ID=455

# 3. Clear cache
php artisan config:clear && php artisan cache:clear

# 4. Test
php test-rajaongkir.php

# 5. Refresh browser & ketik "tangerang"
```

**Selesai! 🎊**

---

*Last Updated: November 8, 2025*

