<?php
// Test upload configuration
echo "<h2>PHP Upload Configuration</h2>";
echo "upload_max_filesize: " . ini_get('upload_max_filesize') . "<br>";
echo "post_max_size: " . ini_get('post_max_size') . "<br>";
echo "max_file_uploads: " . ini_get('max_file_uploads') . "<br>";
echo "memory_limit: " . ini_get('memory_limit') . "<br>";

echo "<h2>Directory Permissions</h2>";
$uploadDir = 'public/uploads/profile/';
echo "Upload directory: " . $uploadDir . "<br>";
echo "Directory exists: " . (is_dir($uploadDir) ? 'Yes' : 'No') . "<br>";
echo "Directory writable: " . (is_writable($uploadDir) ? 'Yes' : 'No') . "<br>";

if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
    echo "Created directory: " . $uploadDir . "<br>";
}

echo "<h2>Test File Upload</h2>";
?>
<form method="post" enctype="multipart/form-data">
    <input type="file" name="test_photo" accept="image/*">
    <button type="submit">Test Upload</button>
</form>

<?php
if ($_POST && isset($_FILES['test_photo'])) {
    $file = $_FILES['test_photo'];
    echo "<h3>Upload Test Result:</h3>";
    echo "File name: " . $file['name'] . "<br>";
    echo "File size: " . $file['size'] . " bytes<br>";
    echo "File type: " . $file['type'] . "<br>";
    echo "Error code: " . $file['error'] . "<br>";
    
    if ($file['error'] === 0) {
        $newName = uniqid() . '_' . $file['name'];
        if (move_uploaded_file($file['tmp_name'], $uploadDir . $newName)) {
            echo "<strong>SUCCESS: File uploaded as " . $newName . "</strong><br>";
            echo "<img src='" . $uploadDir . $newName . "' style='max-width: 200px;'>";
        } else {
            echo "<strong>FAILED: Could not move uploaded file</strong><br>";
        }
    } else {
        echo "<strong>UPLOAD ERROR: " . $file['error'] . "</strong><br>";
    }
}
?>