<?php
// Simple upload test to verify basic functionality
$uploadDir = 'public/uploads/profile/';

// Create directory if not exists
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
    echo "Created directory: $uploadDir<br>";
}

echo "<h2>Simple Upload Test</h2>";
echo "Upload directory: $uploadDir<br>";
echo "Directory exists: " . (is_dir($uploadDir) ? 'Yes' : 'No') . "<br>";
echo "Directory writable: " . (is_writable($uploadDir) ? 'Yes' : 'No') . "<br>";
echo "PHP file uploads enabled: " . (ini_get('file_uploads') ? 'Yes' : 'No') . "<br>";
echo "Max upload size: " . ini_get('upload_max_filesize') . "<br>";
echo "Max post size: " . ini_get('post_max_size') . "<br>";

?>
<form method="post" enctype="multipart/form-data">
    <p>Select image file:</p>
    <input type="file" name="photo" accept="image/*" required>
    <button type="submit" name="upload">Upload</button>
</form>

<?php
if (isset($_POST['upload']) && isset($_FILES['photo'])) {
    $file = $_FILES['photo'];
    
    echo "<h3>Upload Details:</h3>";
    echo "Original name: " . htmlspecialchars($file['name']) . "<br>";
    echo "Size: " . $file['size'] . " bytes<br>";
    echo "Type: " . htmlspecialchars($file['type']) . "<br>";
    echo "Error: " . $file['error'] . "<br>";
    
    if ($file['error'] === 0) {
        $extension = pathinfo($file['name'], PATHINFO_EXTENSION);
        $newName = uniqid() . '.' . $extension;
        $targetPath = $uploadDir . $newName;
        
        echo "Target: $targetPath<br>";
        
        if (move_uploaded_file($file['tmp_name'], $targetPath)) {
            echo "<strong style='color: green;'>SUCCESS!</strong><br>";
            echo "<img src='$targetPath' style='max-width: 200px; border: 2px solid green;'><br>";
            
            // Test if file is accessible via web
            $webPath = str_replace('public/', '', $targetPath);
            echo "Web URL: <a href='$webPath' target='_blank'>$webPath</a><br>";
        } else {
            echo "<strong style='color: red;'>FAILED to move file</strong><br>";
        }
    } else {
        echo "<strong style='color: red;'>Upload error: " . $file['error'] . "</strong><br>";
    }
}
?>