<?php

// Simple test to check if biodata admin functionality is working
require_once 'vendor/autoload.php';

// Initialize CodeIgniter
$app = \Config\Services::codeigniter();
$app->initialize();

// Test database connection and biodata model
try {
    $biodataModel = new \App\Models\BiodataModel();
    
    echo "=== BIODATA ADMIN TEST ===\n";
    echo "1. Testing database connection...\n";
    
    // Get all biodata records
    $biodata = $biodataModel->findAll();
    echo "   Found " . count($biodata) . " biodata records\n";
    
    if (count($biodata) > 0) {
        echo "2. Testing biodata retrieval...\n";
        $firstBiodata = $biodata[0];
        echo "   First record: ID=" . $firstBiodata['id'] . ", Name=" . $firstBiodata['nama'] . "\n";
        
        echo "3. Testing biodata edit retrieval...\n";
        $editBiodata = $biodataModel->where('id', $firstBiodata['id'])->first();
        if ($editBiodata) {
            echo "   Edit data retrieved successfully for ID: " . $editBiodata['id'] . "\n";
        } else {
            echo "   ERROR: Could not retrieve edit data\n";
        }
        
        echo "4. Testing biodata update...\n";
        $updateData = [
            'deskripsi' => 'Test update at ' . date('Y-m-d H:i:s')
        ];
        $result = $biodataModel->update($firstBiodata['id'], $updateData);
        if ($result) {
            echo "   Update successful\n";
        } else {
            echo "   ERROR: Update failed\n";
        }
    } else {
        echo "   No biodata records found. Please run BiodataSeeder first.\n";
    }
    
    echo "\n=== ADMIN AUTH TEST ===\n";
    echo "5. Testing admin model...\n";
    
    $adminModel = new \App\Models\AdminModel();
    $admins = $adminModel->findAll();
    echo "   Found " . count($admins) . " admin records\n";
    
    if (count($admins) > 0) {
        $firstAdmin = $admins[0];
        echo "   First admin: ID=" . $firstAdmin['id'] . ", Username=" . $firstAdmin['username'] . "\n";
        
        $adminCheck = $adminModel->getAdmin($firstAdmin['id']);
        if ($adminCheck) {
            echo "   Admin retrieval working correctly\n";
        } else {
            echo "   ERROR: Admin retrieval failed\n";
        }
    }
    
    echo "\n=== ROUTE TEST ===\n";
    echo "6. Testing route patterns...\n";
    echo "   Biodata edit route should be: /admin/biodata/edit/{id}\n";
    echo "   Activities edit route should be: /admin/activities/{id}/edit\n";
    echo "   Education edit route should be: /admin/education/{id}/edit\n";
    
    echo "\n=== TEST COMPLETED ===\n";
    echo "All basic functionality appears to be working.\n";
    echo "If you're still getting 404 errors, check:\n";
    echo "1. Web server configuration (.htaccess)\n";
    echo "2. Admin session authentication\n";
    echo "3. Route caching (try clearing cache)\n";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}