<?php
// Debug upload functionality
echo "<h2>Upload Debug Test</h2>";

// Check PHP configuration
echo "<h3>PHP Configuration:</h3>";
echo "upload_max_filesize: " . ini_get('upload_max_filesize') . "<br>";
echo "post_max_size: " . ini_get('post_max_size') . "<br>";
echo "max_file_uploads: " . ini_get('max_file_uploads') . "<br>";
echo "file_uploads: " . (ini_get('file_uploads') ? 'Enabled' : 'Disabled') . "<br>";

// Check directory
$uploadDir = 'public/uploads/profile/';
echo "<h3>Directory Check:</h3>";
echo "Upload directory: " . $uploadDir . "<br>";
echo "Directory exists: " . (is_dir($uploadDir) ? 'Yes' : 'No') . "<br>";
echo "Directory writable: " . (is_writable($uploadDir) ? 'Yes' : 'No') . "<br>";

// Create directory if not exists
if (!is_dir($uploadDir)) {
    if (mkdir($uploadDir, 0755, true)) {
        echo "Created directory successfully<br>";
    } else {
        echo "Failed to create directory<br>";
    }
}

// Test form
echo "<h3>Test Upload Form:</h3>";
?>
<form method="post" enctype="multipart/form-data">
    <input type="file" name="test_photo" accept="image/*" required>
    <button type="submit" name="upload">Test Upload</button>
</form>

<?php
if (isset($_POST['upload']) && isset($_FILES['test_photo'])) {
    $file = $_FILES['test_photo'];
    
    echo "<h3>Upload Result:</h3>";
    echo "File name: " . htmlspecialchars($file['name']) . "<br>";
    echo "File size: " . $file['size'] . " bytes<br>";
    echo "File type: " . htmlspecialchars($file['type']) . "<br>";
    echo "Error code: " . $file['error'] . "<br>";
    echo "Temp name: " . htmlspecialchars($file['tmp_name']) . "<br>";
    
    // Error codes explanation
    $errors = [
        0 => 'No error',
        1 => 'File too large (upload_max_filesize)',
        2 => 'File too large (MAX_FILE_SIZE)',
        3 => 'Partial upload',
        4 => 'No file uploaded',
        6 => 'Missing temp folder',
        7 => 'Failed to write to disk',
        8 => 'Extension stopped upload'
    ];
    
    echo "Error meaning: " . ($errors[$file['error']] ?? 'Unknown error') . "<br>";
    
    if ($file['error'] === 0) {
        // Validate file type
        $allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif'];
        if (in_array($file['type'], $allowedTypes)) {
            $newName = uniqid() . '_' . basename($file['name']);
            $targetPath = $uploadDir . $newName;
            
            echo "Target path: " . $targetPath . "<br>";
            
            if (move_uploaded_file($file['tmp_name'], $targetPath)) {
                echo "<strong style='color: green;'>SUCCESS: File uploaded as " . $newName . "</strong><br>";
                echo "<img src='" . $targetPath . "' style='max-width: 200px; border: 2px solid green;'><br>";
                echo "File URL: <a href='" . $targetPath . "' target='_blank'>" . $targetPath . "</a><br>";
            } else {
                echo "<strong style='color: red;'>FAILED: Could not move uploaded file</strong><br>";
                echo "Check directory permissions and PHP error log<br>";
            }
        } else {
            echo "<strong style='color: red;'>INVALID FILE TYPE: " . $file['type'] . "</strong><br>";
            echo "Allowed types: " . implode(', ', $allowedTypes) . "<br>";
        }
    } else {
        echo "<strong style='color: red;'>UPLOAD ERROR: " . $errors[$file['error']] . "</strong><br>";
    }
}
?>