<!-- Admin Login Widget -->
<div class="admin-login-widget">
    <div class="widget-card">
        <div class="widget-header">
            <div class="widget-icon">
                <svg width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                    <path d="M8 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0zm4 8c0 1-1 1-1 1H3s-1 0-1-1 1-4 6-4 6 3 6 4zm-1-.004c-.001-.246-.154-.986-.832-1.664C11.516 10.68 10.289 10 8 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10z"/>
                </svg>
            </div>
            <h6 class="widget-title">Admin Access</h6>
        </div>
        <div class="widget-body">
            <p class="widget-description">
                Akses panel administrasi untuk mengelola konten website
            </p>
            <a href="<?= base_url('admin/login') ?>" class="btn btn-admin-widget">
                <svg width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                    <path d="M8 1a2 2 0 0 1 2 2v4H6V3a2 2 0 0 1 2-2zM3 6a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V6z"/>
                </svg>
                Login Admin
            </a>
        </div>
    </div>
</div>

<style>
.admin-login-widget {
    margin: 20px 0;
}

.widget-card {
    background: linear-gradient(135deg, rgba(102, 126, 234, 0.05) 0%, rgba(118, 75, 162, 0.05) 100%);
    border: 1px solid rgba(102, 126, 234, 0.2);
    border-radius: 12px;
    padding: 20px;
    transition: all 0.3s ease;
}

.widget-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.15);
    border-color: rgba(102, 126, 234, 0.3);
}

.widget-header {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 15px;
}

.widget-icon {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
}

.widget-title {
    margin: 0;
    color: #333;
    font-weight: 600;
    font-size: 16px;
}

.widget-description {
    color: #666;
    font-size: 14px;
    margin-bottom: 15px;
    line-height: 1.5;
}

.btn-admin-widget {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 8px;
    text-decoration: none;
    font-weight: 500;
    font-size: 14px;
    transition: all 0.3s ease;
}

.btn-admin-widget:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
    color: white;
    text-decoration: none;
}

.btn-admin-widget svg {
    width: 16px;
    height: 16px;
}

@media (max-width: 768px) {
    .widget-card {
        padding: 15px;
    }
    
    .widget-icon {
        width: 35px;
        height: 35px;
    }
    
    .widget-title {
        font-size: 15px;
    }
    
    .widget-description {
        font-size: 13px;
    }
    
    .btn-admin-widget {
        padding: 8px 16px;
        font-size: 13px;
    }
}
</style>