<?php
$uri = service('uri');
$segment1 = $uri->getSegment(1) ?: 'home';
$isHome = ($segment1 === 'home' || $segment1 === '');

$pages = [
    'home' => [
        'eyebrow'  => 'Selamat Datang',
        'title'    => 'Halo, Saya Dodi Iskandar',
        'subtitle' => 'Pengembang Web & Mahasiswa',
        'desc'     => 'Passionate dalam bidang teknologi dan pengembangan web. Selalu bersemangat untuk belajar hal-hal baru dan mengembangkan keterampilan pemrograman.',
        'cta_main' => ['label' => 'Lihat Aktivitas',  'href' => base_url('activities#main-content')],
        'cta_alt'  => ['label' => 'Lihat Biodata',    'href' => base_url('biodata')],
        'cta_soft' => ['label' => 'Lihat Pendidikan', 'href' => base_url('education')],
        'initials' => 'DI',
    ],
    'activities' => [
        'eyebrow'  => 'DI BALIK LAYAR',
        'title'    => 'Rutinitas Pengembang Muda',
        'subtitle' => 'Bagaimana Hari Saya Berjalan',
        'desc'     => 'Dokumentasi proyek, galeri foto pekerjaan, dan pembaruan video dari aktivitas harian saya.',
        'cta_main' => ['label' => 'Lihat Aktivitas',  'href' => base_url('activities#main-content')],
        'cta_alt'  => ['label' => 'Lihat Biodata',    'href' => base_url('biodata')],
        'cta_soft' => ['label' => 'Lihat Pendidikan', 'href' => base_url('education')],
        'initials' => 'DI',
    ],
    'biodata' => [
        'eyebrow'  => 'Profil',
        'title'    => 'Biodata & Keterampilan',
        'subtitle' => 'Kenali saya lebih dekat',
        'desc'     => 'Info pribadi yang detail, ringkasan pengalaman freelance proyek, dan semua keterampilan yang saya miliki.',
        'cta_main' => ['label' => 'Lihat Biodata',    'href' => base_url('biodata#main-content')],
        'cta_alt'  => ['label' => 'Lihat Aktivitas',  'href' => base_url('activities')],
        'cta_soft' => ['label' => 'Lihat Pendidikan', 'href' => base_url('education')],
        'initials' => 'DI',
    ],
    'education' => [
        'eyebrow'  => 'Perjalanan Ilmu',
        'title'    => 'Riwayat Pendidikan',
        'subtitle' => 'Belajar dan bertumbuh',
        'desc'     => 'Perjalanan akademis, perolehan gelar, disertai dengan detail bidang dan fokus studi utama.',
        'cta_main' => ['label' => 'Lihat Pendidikan', 'href' => base_url('education#main-content')],
        'cta_alt'  => ['label' => 'Lihat Aktivitas',  'href' => base_url('activities')],
        'cta_soft' => ['label' => 'Lihat Biodata',    'href' => base_url('biodata')],
        'initials' => 'DI',
    ],
    'about' => [
        'eyebrow'  => 'Tentang Saya',
        'title'    => 'Sekilas Cerita',
        'subtitle' => 'Halaman sederhana',
        'desc'     => 'Halaman singkat yang menjelaskan profil dan tujuan pembuatan aplikasi.',
        'cta_main' => ['label' => 'Pelajari',         'href' => base_url('#main-content')],
        'cta_alt'  => ['label' => 'Lihat Aktivitas',  'href' => base_url('activities')],
        'cta_soft' => ['label' => 'Lihat Biodata',    'href' => base_url('biodata')],
        'initials' => 'DI',
    ],
    'contact' => [
        'eyebrow'  => 'Kontak',
        'title'    => 'Mari Terhubung',
        'subtitle' => 'Siap diajak diskusi',
        'desc'     => 'Hubungi saya melalui informasi kontak berikut.',
        'cta_main' => ['label' => 'Hubungi',          'href' => base_url('#main-content')],
        'cta_alt'  => ['label' => 'Lihat Aktivitas',  'href' => base_url('activities')],
        'cta_soft' => ['label' => 'Lihat Pendidikan', 'href' => base_url('education')],
        'initials' => 'DI',
    ],
    'faqs' => [
        'eyebrow'  => 'Pertanyaan Umum',
        'title'    => 'Jawaban Singkat',
        'subtitle' => 'FAQ',
        'desc'     => 'Jawaban singkat untuk pertanyaan yang sering diajukan.',
        'cta_main' => ['label' => 'Baca FAQ',         'href' => base_url('#main-content')],
        'cta_alt'  => ['label' => 'Lihat Aktivitas',  'href' => base_url('activities')],
        'cta_soft' => ['label' => 'Lihat Biodata',    'href' => base_url('biodata')],
        'initials' => 'DI',
    ],
];

$page = $pages[$segment1] ?? $pages['activities'];
?>
<div class="hero-wrap">
    <div class="container hero-grid">
        <div class="hero-copy">
            <div class="hero-eyebrow"><?= esc($page['eyebrow']) ?></div>
            <h1 class="hero-title"><?= esc($page['title']) ?></h1>
            <?php if (!empty($page['subtitle'])): ?>
                <p class="hero-subtitle"><?= esc($page['subtitle']) ?></p>
            <?php endif; ?>
            <p class="hero-desc"><?= esc($page['desc']) ?></p>
            <div class="hero-actions">
                <a href="<?= esc($page['cta_main']['href']) ?>" class="btn-solid"><?= esc($page['cta_main']['label']) ?></a>
                <a href="<?= esc($page['cta_alt']['href']) ?>" class="btn-ghost"><?= esc($page['cta_alt']['label']) ?></a>
                <a href="<?= esc($page['cta_soft']['href']) ?>" class="btn-soft"><?= esc($page['cta_soft']['label']) ?></a>
            </div>
        </div>
        <div class="hero-visual">
            <div class="hero-orb">
                <span><?= esc($page['initials']) ?></span>
            </div>
            <div class="hero-orb-sm"></div>
        </div>
    </div>

    <?php if ($isHome): ?>
        <div class="container feature-grid">
            <a class="feature-card" href="<?= base_url('activities#main-content') ?>">
                <div class="feature-icon feature-icon-primary">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect x="4" y="5" width="16" height="14" rx="2" stroke="currentColor" stroke-width="1.5"/>
                        <path d="M9 3V7M15 3V7M4 9H20" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"/>
                    </svg>
                </div>
                <div>
                    <p class="feature-label">Aktivitas Harian</p>
                    <p class="feature-text">Dokumentasi proyek, galeri foto pekerjaan, dan pembaruan video dari aktivitas harian saya.</p>
                </div>
            </a>
            <a class="feature-card" href="<?= base_url('biodata') ?>">
                <div class="feature-icon feature-icon-secondary">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="12" cy="8" r="3" stroke="currentColor" stroke-width="1.5"/>
                        <path d="M5 19C6 15.5 8.5 14 12 14C15.5 14 18 15.5 19 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"/>
                    </svg>
                </div>
                <div>
                    <p class="feature-label">Biodata</p>
                    <p class="feature-text">Info pribadi yang detail, ringkasan pengalaman freelance proyek, dan semua skill set yang saya miliki.</p>
                </div>
            </a>
            <a class="feature-card" href="<?= base_url('education') ?>">
                <div class="feature-icon feature-icon-tertiary">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M4 9L12 5L20 9L12 13L4 9Z" stroke="currentColor" stroke-width="1.5" stroke-linejoin="round"/>
                        <path d="M6 10.5V15C6 17 9 19 12 19C15 19 18 17 18 15V10.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
                <div>
                    <p class="feature-label">Riwayat Pendidikan</p>
                    <p class="feature-text">Perjalanan akademis, perolehan gelar, disertai dengan detail bidang dan fokus studi utama.</p>
                </div>
            </a>
        </div>
    <?php endif; ?>
</div>
