<?php
$uri = service('uri');
$segment1 = $uri->getSegment(1);
$active_home = ($segment1 === '' || $segment1 === null || $segment1 === 'home');
$active_activities = ($segment1 == 'activities');
$active_biodata = ($segment1 == 'biodata');
$active_education = ($segment1 == 'education');
?>
<nav class="navbar-custom" id="mainNavbar">
    <div class="container">
        <span class="navbar-brand-text">Dodi Iskandar</span>
        
        <!-- Mobile Toggle Button -->
        <button class="navbar-toggler" id="navToggler" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        
        <!-- Desktop Navigation -->
        <ul class="navbar-nav desktop-nav" id="desktopNav">
            <li>
                <a class="nav-link <?= $active_home ? 'active' : '' ?>" href="<?= base_url('/') ?>">
                    <i class="fas fa-home me-1"></i>
                    Beranda
                </a>
            </li>
            <li>
                <a class="nav-link <?= $active_activities ? 'active' : '' ?>" href="<?= base_url('activities') ?>">
                    <i class="fas fa-briefcase me-1"></i>
                    Aktivitas
                </a>
            </li>
            <li>
                <a class="nav-link <?= $active_biodata ? 'active' : '' ?>" href="<?= base_url('biodata') ?>">
                    <i class="fas fa-user me-1"></i>
                    Biodata
                </a>
            </li>
            <li>
                <a class="nav-link <?= $active_education ? 'active' : '' ?>" href="<?= base_url('education') ?>">
                    <i class="fas fa-graduation-cap me-1"></i>
                    Pendidikan
                </a>
            </li>
            <li>
                <a class="admin-nav-btn" href="<?= base_url('admin/login') ?>">
                    <i class="fas fa-shield-alt"></i>
                    Admin
                </a>
            </li>
        </ul>
        
        <!-- Mobile Navigation Menu -->
        <ul class="navbar-nav mobile-menu" id="mobileNav">
            <li>
                <a class="nav-link <?= $active_home ? 'active' : '' ?>" href="<?= base_url('/') ?>">
                    <i class="fas fa-home me-2"></i>
                    Beranda
                </a>
            </li>
            <li>
                <a class="nav-link <?= $active_activities ? 'active' : '' ?>" href="<?= base_url('activities') ?>">
                    <i class="fas fa-briefcase me-2"></i>
                    Aktivitas
                </a>
            </li>
            <li>
                <a class="nav-link <?= $active_biodata ? 'active' : '' ?>" href="<?= base_url('biodata') ?>">
                    <i class="fas fa-user me-2"></i>
                    Biodata
                </a>
            </li>
            <li>
                <a class="nav-link <?= $active_education ? 'active' : '' ?>" href="<?= base_url('education') ?>">
                    <i class="fas fa-graduation-cap me-2"></i>
                    Pendidikan
                </a>
            </li>
            <li>
                <a class="admin-nav-btn" href="<?= base_url('admin/login') ?>">
                    <i class="fas fa-shield-alt me-2"></i>
                    Admin Panel
                </a>
            </li>
        </ul>
    </div>
</nav>