<?= $this->extend('layout/post_layout') ?>

<?= $this->section('content') ?>
<div class="admin-access-page">
    <div class="page-header">
        <h1 class="page-title">Admin Access</h1>
        <p class="page-subtitle">Berbagai cara untuk mengakses panel administrasi website</p>
    </div>

    <div class="access-methods">
        <div class="row">
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="access-card">
                    <div class="access-icon primary">
                        <svg width="32" height="32" fill="currentColor" viewBox="0 0 16 16">
                            <path d="M8 1a2 2 0 0 1 2 2v4H6V3a2 2 0 0 1 2-2zM3 6a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V6z"/>
                        </svg>
                    </div>
                    <h3 class="access-title">Direct Login</h3>
                    <p class="access-description">
                        Akses langsung ke halaman login admin dengan tombol di bawah ini
                    </p>
                    <a href="<?= base_url('admin/login') ?>" class="btn btn-access primary">
                        Login Sekarang
                        <svg width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"/>
                        </svg>
                    </a>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4">
                <div class="access-card">
                    <div class="access-icon secondary">
                        <svg width="32" height="32" fill="currentColor" viewBox="0 0 16 16">
                            <path d="M0 2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2zm15 2L1 4v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4z"/>
                        </svg>
                    </div>
                    <h3 class="access-title">Navbar Link</h3>
                    <p class="access-description">
                        Gunakan link "Admin" di navigation bar yang tersedia di setiap halaman
                    </p>
                    <div class="access-demo">
                        <div class="demo-navbar">
                            <span>Portfolio</span>
                            <div class="demo-nav-items">
                                <span>Beranda</span>
                                <span>Aktivitas</span>
                                <span class="demo-admin-link">Admin</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4">
                <div class="access-card">
                    <div class="access-icon tertiary">
                        <svg width="32" height="32" fill="currentColor" viewBox="0 0 16 16">
                            <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                            <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4z"/>
                        </svg>
                    </div>
                    <h3 class="access-title">Floating Button</h3>
                    <p class="access-description">
                        Tombol floating yang muncul saat scroll ke bawah untuk akses cepat
                    </p>
                    <div class="access-demo">
                        <div class="demo-floating">
                            <div class="demo-floating-btn">
                                <svg width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M8 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0zm4 8c0 1-1 1-1 1H3s-1 0-1-1 1-4 6-4 6 3 6 4z"/>
                                </svg>
                            </div>
                            <span class="demo-tooltip">Login Admin</span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6 col-md-6 mb-4">
                <div class="access-card">
                    <div class="access-icon success">
                        <svg width="32" height="32" fill="currentColor" viewBox="0 0 16 16">
                            <path d="M8.515 1.019A7 7 0 0 0 8 1V0a8 8 0 0 1 .589.022l-.074.997zm2.004.45a7.003 7.003 0 0 0-.985-.299l.219-.976c.383.086.76.2 1.126.342l-.36.933zm1.37.71a7.01 7.01 0 0 0-.439-.27l.493-.87a8.025 8.025 0 0 1 .979.654l-.615.789a6.996 6.996 0 0 0-.418-.302zm1.834 1.79a6.99 6.99 0 0 0-.653-.796l.724-.69c.27.285.52.59.747.91l-.818.576zm.744 1.352a7.08 7.08 0 0 0-.214-.468l.893-.45a7.976 7.976 0 0 1 .45 1.088l-.95.313a7.023 7.023 0 0 0-.179-.483zm.53 2.507a6.991 6.991 0 0 0-.1-1.025l.985-.17c.067.386.106.778.116 1.17l-1.001.025zm-.131 1.538c.033-.17.06-.339.081-.51l.993.123a7.957 7.957 0 0 1-.23 1.155l-.964-.267c.046-.165.086-.332.12-.501zm-.952 2.379c.184-.29.346-.594.486-.908l.914.405c-.16.36-.345.706-.555 1.038l-.845-.535zm-.964 1.205c.122-.122.239-.248.35-.378l.758.653a8.073 8.073 0 0 1-.401.432l-.707-.707z"/>
                            <path d="M8 1a7 7 0 1 0 4.95 11.95l.707.707A8.001 8.001 0 1 1 8 0v1z"/>
                            <path d="M7.5 3a.5.5 0 0 1 .5.5v5.21l3.248 1.856a.5.5 0 0 1-.496.868l-3.5-2A.5.5 0 0 1 7 9V3.5a.5.5 0 0 1 .5-.5z"/>
                        </svg>
                    </div>
                    <h3 class="access-title">Home Panel</h3>
                    <p class="access-description">
                        Panel khusus admin login tersedia di halaman beranda dalam section "Highlights"
                    </p>
                    <a href="<?= base_url('/') ?>#main-content" class="btn btn-access success">
                        Lihat di Beranda
                        <svg width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"/>
                        </svg>
                    </a>
                </div>
            </div>

            <div class="col-lg-6 col-md-6 mb-4">
                <div class="access-card">
                    <div class="access-icon warning">
                        <svg width="32" height="32" fill="currentColor" viewBox="0 0 16 16">
                            <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.354 4.646a.5.5 0 1 0-.708.708L7.293 8l-2.647 2.646a.5.5 0 0 0 .708.708L8 8.707l2.646 2.647a.5.5 0 0 0 .708-.708L8.707 8l2.647-2.646a.5.5 0 0 0-.708-.708L8 7.293 5.354 4.646z"/>
                        </svg>
                    </div>
                    <h3 class="access-title">Footer Link</h3>
                    <p class="access-description">
                        Link admin juga tersedia di footer setiap halaman untuk akses yang mudah
                    </p>
                    <div class="access-demo">
                        <div class="demo-footer">
                            <span>© 2025 Dodi Iskandar</span>
                            <div class="demo-footer-admin">Admin</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="access-info">
        <div class="info-card">
            <div class="info-header">
                <svg width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                    <path d="m8.93 6.588-2.29.287-.082.38.45.083c.294.07.352.176.288.469l-.738 3.468c-.194.897.105 1.319.808 1.319.545 0 1.178-.252 1.465-.598l.088-.416c-.2.176-.492.246-.686.246-.275 0-.375-.193-.304-.533L8.93 6.588zM9 4.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0z"/>
                </svg>
                <h4>Informasi Login</h4>
            </div>
            <div class="info-content">
                <div class="row">
                    <div class="col-md-6">
                        <h6>Default Login:</h6>
                        <ul class="login-info">
                            <li><strong>Username:</strong> admin</li>
                            <li><strong>Password:</strong> admin123</li>
                            <li><strong>Email:</strong> admin@example.com</li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <h6>Fitur Admin:</h6>
                        <ul class="feature-list">
                            <li>Kelola Activities</li>
                            <li>Kelola Biodata</li>
                            <li>Kelola Education</li>
                            <li>Dashboard Analytics</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.admin-access-page {
    max-width: 1200px;
    margin: 0 auto;
    padding: 40px 20px;
}

.page-header {
    text-align: center;
    margin-bottom: 50px;
}

.page-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: #333;
    margin-bottom: 10px;
}

.page-subtitle {
    font-size: 1.1rem;
    color: #666;
    max-width: 600px;
    margin: 0 auto;
}

.access-methods {
    margin-bottom: 50px;
}

.access-card {
    background: white;
    border-radius: 16px;
    padding: 30px;
    height: 100%;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
    border: 1px solid rgba(0, 0, 0, 0.05);
}

.access-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
}

.access-icon {
    width: 70px;
    height: 70px;
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 20px;
    color: white;
}

.access-icon.primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.access-icon.secondary {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
}

.access-icon.tertiary {
    background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
}

.access-icon.success {
    background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
}

.access-icon.warning {
    background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
}

.access-title {
    font-size: 1.4rem;
    font-weight: 600;
    color: #333;
    margin-bottom: 15px;
}

.access-description {
    color: #666;
    line-height: 1.6;
    margin-bottom: 20px;
}

.btn-access {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 24px;
    border-radius: 10px;
    text-decoration: none;
    font-weight: 500;
    transition: all 0.3s ease;
    border: none;
}

.btn-access.primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.btn-access.success {
    background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
    color: white;
}

.btn-access:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
    color: white;
    text-decoration: none;
}

.access-demo {
    margin-top: 20px;
}

.demo-navbar {
    background: #f8f9fa;
    padding: 10px 15px;
    border-radius: 8px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    font-size: 14px;
}

.demo-nav-items {
    display: flex;
    gap: 15px;
}

.demo-admin-link {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 4px 12px;
    border-radius: 15px;
    font-size: 12px;
}

.demo-floating {
    display: flex;
    align-items: center;
    gap: 10px;
    justify-content: center;
}

.demo-floating-btn {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
}

.demo-tooltip {
    background: rgba(0, 0, 0, 0.8);
    color: white;
    padding: 4px 8px;
    border-radius: 4px;
    font-size: 12px;
}

.demo-footer {
    background: #f8f9fa;
    padding: 10px 15px;
    border-radius: 8px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    font-size: 14px;
}

.demo-footer-admin {
    background: rgba(102, 126, 234, 0.1);
    color: #667eea;
    padding: 4px 10px;
    border-radius: 12px;
    font-size: 12px;
    border: 1px solid rgba(102, 126, 234, 0.2);
}

.info-card {
    background: linear-gradient(135deg, rgba(102, 126, 234, 0.05) 0%, rgba(118, 75, 162, 0.05) 100%);
    border: 1px solid rgba(102, 126, 234, 0.1);
    border-radius: 16px;
    padding: 30px;
}

.info-header {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 20px;
    color: #667eea;
}

.info-header h4 {
    margin: 0;
    font-weight: 600;
}

.login-info, .feature-list {
    list-style: none;
    padding: 0;
}

.login-info li, .feature-list li {
    padding: 5px 0;
    color: #666;
}

.login-info strong {
    color: #333;
}

.feature-list li::before {
    content: "✓";
    color: #28a745;
    font-weight: bold;
    margin-right: 8px;
}

@media (max-width: 768px) {
    .page-title {
        font-size: 2rem;
    }
    
    .access-card {
        padding: 20px;
    }
    
    .access-icon {
        width: 60px;
        height: 60px;
    }
    
    .demo-navbar, .demo-footer {
        flex-direction: column;
        gap: 10px;
        text-align: center;
    }
    
    .demo-nav-items {
        justify-content: center;
    }
}
</style>
<?= $this->endSection() ?>