<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 mb-0">Kelola Admin</h1>
        <p class="text-muted">Manajemen akun administrator sistem</p>
    </div>
    <a href="<?= base_url('admin/management/create') ?>" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>
        Tambah Admin
    </a>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Username</th>
                        <th>Email</th>
                        <th>Nama Lengkap</th>
                        <th>Role</th>
                        <th>Status</th>
                        <th>Dibuat</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($admins as $admin): ?>
                    <tr>
                        <td><?= $admin['id'] ?></td>
                        <td>
                            <strong><?= esc($admin['username']) ?></strong>
                            <?php if ($admin['id'] == $current_admin['id']): ?>
                                <span class="badge bg-info ms-1">You</span>
                            <?php endif; ?>
                        </td>
                        <td><?= esc($admin['email']) ?></td>
                        <td><?= esc($admin['full_name']) ?></td>
                        <td>
                            <?php if ($admin['role'] === 'super_admin'): ?>
                                <span class="badge bg-danger">Super Admin</span>
                            <?php else: ?>
                                <span class="badge bg-primary">Admin</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($admin['is_active']): ?>
                                <span class="badge bg-success">Aktif</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Nonaktif</span>
                            <?php endif; ?>
                        </td>
                        <td><?= date('d/m/Y', strtotime($admin['created_at'])) ?></td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="<?= base_url('admin/management/' . $admin['id'] . '/edit') ?>" 
                                   class="btn btn-outline-primary" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                
                                <?php if ($admin['role'] !== 'super_admin' && $admin['id'] != $current_admin['id']): ?>
                                    <a href="<?= base_url('admin/management/' . $admin['id'] . '/toggle-status') ?>" 
                                       class="btn btn-outline-warning" 
                                       title="<?= $admin['is_active'] ? 'Nonaktifkan' : 'Aktifkan' ?>"
                                       onclick="return confirm('Yakin ingin mengubah status admin ini?')">
                                        <i class="fas fa-<?= $admin['is_active'] ? 'eye-slash' : 'eye' ?>"></i>
                                    </a>
                                    
                                    <a href="<?= base_url('admin/management/' . $admin['id'] . '/delete') ?>" 
                                       class="btn btn-outline-danger" title="Hapus"
                                       onclick="return confirm('Yakin ingin menghapus admin ini? Tindakan ini tidak dapat dibatalkan.')">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?= $this->endSection() ?>