<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 mb-0">Edit Admin</h1>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('admin/management') ?>">Kelola Admin</a></li>
                <li class="breadcrumb-item active">Edit</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-body">
                <form action="<?= base_url('admin/management/' . $admin['id'] . '/update') ?>" method="post">
                    <?= csrf_field() ?>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="username" class="form-label">Username</label>
                            <input type="text" class="form-control <?= $validation->hasError('username') ? 'is-invalid' : '' ?>" 
                                   id="username" name="username" value="<?= old('username', $admin['username']) ?>" required>
                            <?php if ($validation->hasError('username')): ?>
                                <div class="invalid-feedback">
                                    <?= $validation->getError('username') ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" class="form-control <?= $validation->hasError('email') ? 'is-invalid' : '' ?>" 
                                   id="email" name="email" value="<?= old('email', $admin['email']) ?>" required>
                            <?php if ($validation->hasError('email')): ?>
                                <div class="invalid-feedback">
                                    <?= $validation->getError('email') ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="full_name" class="form-label">Nama Lengkap</label>
                        <input type="text" class="form-control <?= $validation->hasError('full_name') ? 'is-invalid' : '' ?>" 
                               id="full_name" name="full_name" value="<?= old('full_name', $admin['full_name']) ?>" required>
                        <?php if ($validation->hasError('full_name')): ?>
                            <div class="invalid-feedback">
                                <?= $validation->getError('full_name') ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="password" class="form-label">Password Baru (Opsional)</label>
                            <input type="password" class="form-control <?= $validation->hasError('password') ? 'is-invalid' : '' ?>" 
                                   id="password" name="password">
                            <div class="form-text">Kosongkan jika tidak ingin mengubah password</div>
                            <?php if ($validation->hasError('password')): ?>
                                <div class="invalid-feedback">
                                    <?= $validation->getError('password') ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="confirm_password" class="form-label">Konfirmasi Password</label>
                            <input type="password" class="form-control <?= $validation->hasError('confirm_password') ? 'is-invalid' : '' ?>" 
                                   id="confirm_password" name="confirm_password">
                            <?php if ($validation->hasError('confirm_password')): ?>
                                <div class="invalid-feedback">
                                    <?= $validation->getError('confirm_password') ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="role" class="form-label">Role</label>
                            <select class="form-select <?= $validation->hasError('role') ? 'is-invalid' : '' ?>" 
                                    id="role" name="role" required>
                                <option value="">Pilih Role</option>
                                <option value="admin" <?= old('role', $admin['role']) === 'admin' ? 'selected' : '' ?>>Admin</option>
                                <option value="super_admin" <?= old('role', $admin['role']) === 'super_admin' ? 'selected' : '' ?>>Super Admin</option>
                            </select>
                            <?php if ($validation->hasError('role')): ?>
                                <div class="invalid-feedback">
                                    <?= $validation->getError('role') ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="is_active" class="form-label">Status</label>
                            <select class="form-select" id="is_active" name="is_active">
                                <option value="1" <?= old('is_active', $admin['is_active']) == '1' ? 'selected' : '' ?>>Aktif</option>
                                <option value="0" <?= old('is_active', $admin['is_active']) == '0' ? 'selected' : '' ?>>Nonaktif</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>
                            Update
                        </button>
                        <a href="<?= base_url('admin/management') ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>
                            Kembali
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-user me-2"></i>
                    Info Admin
                </h5>
            </div>
            <div class="card-body">
                <p><strong>ID:</strong> <?= $admin['id'] ?></p>
                <p><strong>Dibuat:</strong> <?= date('d/m/Y H:i', strtotime($admin['created_at'])) ?></p>
                <p><strong>Terakhir Update:</strong> <?= date('d/m/Y H:i', strtotime($admin['updated_at'])) ?></p>
                
                <hr>
                
                <h6>Catatan:</h6>
                <ul class="list-unstyled">
                    <li>• Super Admin tidak dapat dinonaktifkan</li>
                    <li>• Anda tidak dapat mengedit akun sendiri</li>
                    <li>• Password kosong = tidak diubah</li>
                </ul>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>