<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 mb-0">Kelola Biodata</h1>
        <p class="text-muted">Manajemen data biodata dan CV</p>
    </div>
    <a href="<?= base_url('admin/biodata/create') ?>" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>
        Tambah Biodata
    </a>
</div>

<!-- Search and Filter -->
<div class="card mb-4">
    <div class="card-body">
        <form method="get" action="<?= base_url('admin/biodata') ?>">
            <div class="row">
                <div class="col-md-4 mb-2">
                    <input type="text" name="search" class="form-control" placeholder="Cari nama, alamat, email..." value="<?= esc($search) ?>">
                </div>
                <div class="col-md-3 mb-2">
                    <select name="filter_jenis_kelamin" class="form-select">
                        <option value="">Semua Jenis Kelamin</option>
                        <option value="Laki-laki" <?= $filter_jenis_kelamin == 'Laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                        <option value="Perempuan" <?= $filter_jenis_kelamin == 'Perempuan' ? 'selected' : '' ?>>Perempuan</option>
                    </select>
                </div>
                <div class="col-md-2 mb-2">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fas fa-search me-1"></i>
                        Cari
                    </button>
                </div>
                <div class="col-md-3 mb-2">
                    <a href="<?= base_url('admin/biodata') ?>" class="btn btn-secondary w-100">
                        <i class="fas fa-refresh me-1"></i>
                        Reset
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Sorting Links -->
<div class="mb-3">
    <small class="text-muted"><strong>Urutkan berdasarkan:</strong></small>
    <div class="btn-group btn-group-sm ms-2">
        <a href="<?= base_url('admin/biodata?sort_by=nama&sort_order=' . ($sort_by == 'nama' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenis_kelamin=' . urlencode($filter_jenis_kelamin)) ?>" 
           class="btn btn-outline-secondary">
            Nama <?= $sort_by == 'nama' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
        <a href="<?= base_url('admin/biodata?sort_by=email&sort_order=' . ($sort_by == 'email' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenis_kelamin=' . urlencode($filter_jenis_kelamin)) ?>" 
           class="btn btn-outline-secondary">
            Email <?= $sort_by == 'email' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
        <a href="<?= base_url('admin/biodata?sort_by=tanggal_lahir&sort_order=' . ($sort_by == 'tanggal_lahir' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenis_kelamin=' . urlencode($filter_jenis_kelamin)) ?>" 
           class="btn btn-outline-secondary">
            Tanggal Lahir <?= $sort_by == 'tanggal_lahir' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
    </div>
</div>

<!-- Data Table -->
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Foto</th>
                        <th>Nama</th>
                        <th>Email</th>
                        <th>No. HP</th>
                        <th>Jenis Kelamin</th>
                        <th>Alamat</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($biodata)): ?>
                        <tr>
                            <td colspan="8" class="text-center py-4">
                                <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                <p class="text-muted">Belum ada data biodata</p>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach($biodata as $bio): ?>
                        <tr>
                            <td><?= $bio['id'] ?></td>
                            <td>
                                <?php if (!empty($bio['foto_profil'])): ?>
                                    <img src="<?= base_url($bio['foto_profil']) ?>" 
                                         class="rounded-circle" 
                                         style="width: 40px; height: 40px; object-fit: cover;" 
                                         alt="Foto">
                                <?php else: ?>
                                    <div class="rounded-circle bg-secondary d-flex align-items-center justify-content-center" 
                                         style="width: 40px; height: 40px;">
                                        <i class="fas fa-user text-white"></i>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td>
                                <strong><?= esc($bio['nama']) ?></strong>
                                <?php if (!empty($bio['tempat_lahir'])): ?>
                                    <br><small class="text-muted"><?= esc($bio['tempat_lahir']) ?></small>
                                <?php endif; ?>
                            </td>
                            <td><?= esc($bio['email']) ?></td>
                            <td><?= esc($bio['no_hp']) ?></td>
                            <td>
                                <span class="badge bg-<?= $bio['jenis_kelamin'] == 'Laki-laki' ? 'primary' : 'danger' ?>">
                                    <?= esc($bio['jenis_kelamin']) ?>
                                </span>
                            </td>
                            <td>
                                <?= esc(substr($bio['alamat'], 0, 50)) ?>
                                <?= strlen($bio['alamat']) > 50 ? '...' : '' ?>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="<?= base_url('admin/biodata/'.$bio['id'].'/preview') ?>" 
                                       class="btn btn-outline-info" title="Preview" target="_blank">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?= base_url('admin/biodata/edit/'.$bio['id']) ?>" 
                                       class="btn btn-outline-primary" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="<?= base_url('admin/biodata/'.$bio['id'].'/delete') ?>" 
                                       class="btn btn-outline-danger" title="Hapus"
                                       onclick="return confirm('Yakin ingin menghapus biodata ini? Data akan hilang permanen.')">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Pagination -->
<?php if ($pager): ?>
<div class="d-flex justify-content-center mt-4">
    <?= $pager->links() ?>
</div>
<?php endif; ?>
<?= $this->endSection() ?>