<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Edit Biodata</h3>
                    <div class="card-tools">
                        <a href="<?= base_url('admin/biodata') ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <?php if (session()->getFlashdata('error')): ?>
                        <div class="alert alert-danger">
                            <?= session()->getFlashdata('error') ?>
                        </div>
                    <?php endif; ?>

                    <form action="<?= base_url('admin/biodata/edit/' . $biodata['id']) ?>" method="post" enctype="multipart/form-data">
                        <?= csrf_field() ?>
                        <input type="hidden" name="id" value="<?= $biodata['id'] ?>">
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nama">Nama Lengkap <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control <?= $validation->hasError('nama') ? 'is-invalid' : '' ?>" 
                                           id="nama" name="nama" value="<?= old('nama', $biodata['nama']) ?>" required>
                                    <?php if ($validation->hasError('nama')): ?>
                                        <div class="invalid-feedback">
                                            <?= $validation->getError('nama') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="email">Email <span class="text-danger">*</span></label>
                                    <input type="email" class="form-control <?= $validation->hasError('email') ? 'is-invalid' : '' ?>" 
                                           id="email" name="email" value="<?= old('email', $biodata['email']) ?>" required>
                                    <?php if ($validation->hasError('email')): ?>
                                        <div class="invalid-feedback">
                                            <?= $validation->getError('email') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="alamat">Alamat</label>
                                    <textarea class="form-control" id="alamat" name="alamat" rows="3"><?= old('alamat', $biodata['alamat']) ?></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="tempat_lahir">Tempat Lahir</label>
                                    <input type="text" class="form-control" id="tempat_lahir" name="tempat_lahir" 
                                           value="<?= old('tempat_lahir', $biodata['tempat_lahir']) ?>">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="tanggal_lahir">Tanggal Lahir</label>
                                    <input type="date" class="form-control" id="tanggal_lahir" name="tanggal_lahir" 
                                           value="<?= old('tanggal_lahir', $biodata['tanggal_lahir']) ?>">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="jenis_kelamin">Jenis Kelamin <span class="text-danger">*</span></label>
                                    <select class="form-control <?= $validation->hasError('jenis_kelamin') ? 'is-invalid' : '' ?>" 
                                            id="jenis_kelamin" name="jenis_kelamin" required>
                                        <option value="">Pilih Jenis Kelamin</option>
                                        <option value="Laki-laki" <?= old('jenis_kelamin', $biodata['jenis_kelamin']) == 'Laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                                        <option value="Perempuan" <?= old('jenis_kelamin', $biodata['jenis_kelamin']) == 'Perempuan' ? 'selected' : '' ?>>Perempuan</option>
                                    </select>
                                    <?php if ($validation->hasError('jenis_kelamin')): ?>
                                        <div class="invalid-feedback">
                                            <?= $validation->getError('jenis_kelamin') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="agama">Agama</label>
                                    <select class="form-control" id="agama" name="agama">
                                        <option value="">Pilih Agama</option>
                                        <option value="Islam" <?= old('agama', $biodata['agama']) == 'Islam' ? 'selected' : '' ?>>Islam</option>
                                        <option value="Kristen" <?= old('agama', $biodata['agama']) == 'Kristen' ? 'selected' : '' ?>>Kristen</option>
                                        <option value="Katolik" <?= old('agama', $biodata['agama']) == 'Katolik' ? 'selected' : '' ?>>Katolik</option>
                                        <option value="Hindu" <?= old('agama', $biodata['agama']) == 'Hindu' ? 'selected' : '' ?>>Hindu</option>
                                        <option value="Buddha" <?= old('agama', $biodata['agama']) == 'Buddha' ? 'selected' : '' ?>>Buddha</option>
                                        <option value="Konghucu" <?= old('agama', $biodata['agama']) == 'Konghucu' ? 'selected' : '' ?>>Konghucu</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="no_hp">No. HP <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control <?= $validation->hasError('no_hp') ? 'is-invalid' : '' ?>" 
                                           id="no_hp" name="no_hp" value="<?= old('no_hp', $biodata['no_hp']) ?>" required>
                                    <?php if ($validation->hasError('no_hp')): ?>
                                        <div class="invalid-feedback">
                                            <?= $validation->getError('no_hp') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="foto_profil">Foto Profil</label>
                                    <input type="file" class="form-control-file" id="foto_profil" name="foto_profil" accept="image/*">
                                    <small class="form-text text-muted">Format: JPG, JPEG, PNG. Maksimal 2MB.</small>
                                    <?php if (!empty($biodata['foto_profil'])): ?>
                                        <div class="mt-2">
                                            <img src="<?= base_url($biodata['foto_profil']) ?>" alt="Current Photo" class="img-thumbnail" style="max-width: 150px;">
                                            <p class="text-muted mt-1">Foto saat ini</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="deskripsi">Deskripsi</label>
                                    <textarea class="form-control" id="deskripsi" name="deskripsi" rows="4" 
                                              placeholder="Deskripsi singkat tentang diri Anda"><?= old('deskripsi', $biodata['deskripsi']) ?></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Biodata
                            </button>
                            <a href="<?= base_url('admin/biodata') ?>" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>