<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<div class="admin-page-header">
    <h1>Biodata / CV</h1>
</div>

<div class="admin-card">
    <a href="<?= base_url('admin/biodata/new') ?>" class="admin-btn admin-btn-primary mb-3">Tambah Biodata Baru</a>

    <!-- Search and Filter Form -->
    <form method="get" action="<?= base_url('admin/biodata') ?>" class="mb-4">
        <div class="row">
            <div class="col-md-4 mb-2">
                <input type="text" name="search" class="admin-form-control" placeholder="Cari nama, alamat, email..." value="<?= esc($search) ?>">
            </div>
            <div class="col-md-3 mb-2">
                <select name="filter_jenis_kelamin" class="admin-form-control">
                    <option value="">Semua Jenis Kelamin</option>
                    <option value="Laki-laki" <?= $filter_jenis_kelamin == 'Laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                    <option value="Perempuan" <?= $filter_jenis_kelamin == 'Perempuan' ? 'selected' : '' ?>>Perempuan</option>
                </select>
            </div>
            <div class="col-md-2 mb-2">
                <button type="submit" class="admin-btn admin-btn-primary w-100">Cari</button>
            </div>
            <div class="col-md-3 mb-2">
                <a href="<?= base_url('admin/biodata') ?>" class="admin-btn admin-btn-secondary w-100">Reset</a>
            </div>
        </div>
    </form>

    <!-- Sorting Links -->
    <div class="mb-3 admin-sort-links">
        <small><strong>Urutkan berdasarkan:</strong></small>
        <a href="<?= base_url('admin/biodata?sort_by=nama&sort_order=' . ($sort_by == 'nama' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenis_kelamin=' . urlencode($filter_jenis_kelamin)) ?>">
            Nama <?= $sort_by == 'nama' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a> |
        <a href="<?= base_url('admin/biodata?sort_by=email&sort_order=' . ($sort_by == 'email' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenis_kelamin=' . urlencode($filter_jenis_kelamin)) ?>">
            Email <?= $sort_by == 'email' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a> |
        <a href="<?= base_url('admin/biodata?sort_by=tanggal_lahir&sort_order=' . ($sort_by == 'tanggal_lahir' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenis_kelamin=' . urlencode($filter_jenis_kelamin)) ?>">
            Tanggal Lahir <?= $sort_by == 'tanggal_lahir' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
    </div>
</div>

<div class="admin-card">
    <table class="admin-table">
<thead>
<tr>
    <th>#</th>
    <th>Nama</th>
    <th>Alamat</th>
    <th>Email</th>
    <th>No. HP</th>
    <th>Jenis Kelamin</th>
    <th>Foto</th>
    <th>Action</th>
</tr>
</thead>
<tbody>
<?php foreach($biodata as $bio): ?>
<tr>
    <td><?= $bio['id'] ?></td>
    <td><?= esc($bio['nama']) ?></td>
    <td><?= esc(substr($bio['alamat'], 0, 50)) ?>...</td>
    <td><?= esc($bio['email']) ?></td>
    <td><?= esc($bio['no_hp']) ?></td>
    <td><?= esc($bio['jenis_kelamin']) ?></td>
    <td>
        <?php if (!empty($bio['foto_profil'])): ?>
            <img src="<?= base_url($bio['foto_profil']) ?>" style="max-width: 50px; max-height: 50px;" alt="Foto">
        <?php else: ?>
            <span class="text-muted">-</span>
        <?php endif; ?>
    </td>
    <td>
        <a href="<?= base_url('admin/biodata/'.$bio['id'].'/preview') ?>" class="admin-btn admin-btn-secondary" style="padding: 0.3rem 0.6rem; font-size: 0.85rem;" target="_blank">Preview</a>
        <a href="<?= base_url('admin/biodata/'.$bio['id'].'/edit') ?>" class="admin-btn admin-btn-success" style="padding: 0.3rem 0.6rem; font-size: 0.85rem;">Edit</a>
        <a href="#" data-href="<?= base_url('admin/biodata/'.$bio['id'].'/delete') ?>" onclick="confirmToDelete(this)" class="admin-btn admin-btn-danger" style="padding: 0.3rem 0.6rem; font-size: 0.85rem;">Delete</a>
    </td>
</tr>
<?php endforeach ?>
</tbody>
    </table>
</div>

<!-- Pagination -->
<div class="mt-4">
    <?= $pager->links() ?>
</div>

<div id="confirm-dialog" class="modal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-body">
        <h2 class="h2">Are you sure?</h2>
        <p>The data will be deleted and lost forever</p>
      </div>
      <div class="modal-footer">
        <a href="#" role="button" id="delete-button" class="admin-btn admin-btn-danger">Delete</a>
        <button type="button" class="admin-btn admin-btn-secondary" data-dismiss="modal">Cancel</button>
      </div>
    </div>
  </div>
</div>

<script>
function confirmToDelete(el){
    $("#delete-button").attr("href", el.dataset.href);
    $("#confirm-dialog").modal('show');
}
</script>

<?= $this->endSection() ?>







