<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<div class="admin-page-header">
    <h1>Edit Aktivitas</h1>
</div>

<div class="admin-card">
    <form action="" method="post" enctype="multipart/form-data">
        <input type="hidden" name="id" value="<?= $activity['id'] ?>">

        <div class="admin-form-group">
            <label for="tanggal">Tanggal</label>
            <input type="date" name="tanggal" class="admin-form-control" value="<?= $activity['tanggal'] ?>" required>
        </div>
        <div class="admin-form-group">
            <label for="jam">Jam</label>
            <input type="time" name="jam" class="admin-form-control" value="<?= date('H:i', strtotime($activity['jam'])) ?>" required>
        </div>
        <div class="admin-form-group">
            <label for="nama_aktivitas">Nama Aktivitas</label>
            <input type="text" name="nama_aktivitas" class="admin-form-control" value="<?= esc($activity['nama_aktivitas']) ?>" required>
        </div>
        <div class="admin-form-group">
            <label for="foto">Foto</label>
            <?php if (!empty($activity['foto'])): ?>
                <div class="mb-3">
                    <img src="<?= base_url($activity['foto']) ?>" style="max-width: 220px; border-radius: 12px;" alt="Foto saat ini">
                    <p class="text-muted mb-0">Foto saat ini</p>
                </div>
            <?php endif; ?>
            <input type="file" name="foto" class="admin-form-control" accept="image/*">
            <small class="text-muted d-block mt-1">Kosongkan jika tidak ingin mengubah foto</small>
        </div>
        <div class="admin-form-group">
            <label for="video">Video</label>
            <?php if (!empty($activity['video'])): ?>
                <div class="mb-3">
                    <video width="260" controls style="border-radius:12px;">
                        <source src="<?= base_url($activity['video']) ?>" type="video/mp4">
                    </video>
                    <p class="text-muted mb-0">Video saat ini</p>
                </div>
            <?php endif; ?>
            <input type="file" name="video" class="admin-form-control" accept="video/*">
            <small class="text-muted d-block mt-1">Kosongkan jika tidak ingin mengubah video</small>
        </div>
        <div class="admin-form-group d-flex gap-2">
            <button type="submit" class="admin-btn admin-btn-primary">Update</button>
            <a href="<?= base_url('admin/activities') ?>" class="admin-btn admin-btn-secondary">Batal</a>
        </div>
    </form>
</div>

<?= $this->endSection() ?>







