<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Edit Aktivitas</h3>
                    <div class="card-tools">
                        <a href="<?= base_url('admin/activities') ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <?php if (session()->getFlashdata('error')): ?>
                        <div class="alert alert-danger">
                            <?= session()->getFlashdata('error') ?>
                        </div>
                    <?php endif; ?>

                    <form action="<?= base_url('admin/activities/edit/' . $activity['id']) ?>" method="post" enctype="multipart/form-data">
                        <?= csrf_field() ?>
                        <input type="hidden" name="id" value="<?= $activity['id'] ?>">
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nama_aktivitas">Nama Aktivitas <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control <?= $validation->hasError('nama_aktivitas') ? 'is-invalid' : '' ?>" 
                                           id="nama_aktivitas" name="nama_aktivitas" value="<?= old('nama_aktivitas', $activity['nama_aktivitas']) ?>" required>
                                    <?php if ($validation->hasError('nama_aktivitas')): ?>
                                        <div class="invalid-feedback">
                                            <?= $validation->getError('nama_aktivitas') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="tanggal">Tanggal <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control <?= $validation->hasError('tanggal') ? 'is-invalid' : '' ?>" 
                                           id="tanggal" name="tanggal" value="<?= old('tanggal', $activity['tanggal']) ?>" required>
                                    <?php if ($validation->hasError('tanggal')): ?>
                                        <div class="invalid-feedback">
                                            <?= $validation->getError('tanggal') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="jam">Jam <span class="text-danger">*</span></label>
                                    <input type="time" class="form-control <?= $validation->hasError('jam') ? 'is-invalid' : '' ?>" 
                                           id="jam" name="jam" value="<?= old('jam', $activity['jam']) ?>" required>
                                    <?php if ($validation->hasError('jam')): ?>
                                        <div class="invalid-feedback">
                                            <?= $validation->getError('jam') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="deskripsi">Deskripsi</label>
                                    <textarea class="form-control" id="deskripsi" name="deskripsi" rows="4" 
                                              placeholder="Deskripsi aktivitas"><?= old('deskripsi', $activity['deskripsi']) ?></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="foto">Foto</label>
                                    <input type="file" class="form-control-file" id="foto" name="foto" accept="image/*">
                                    <small class="form-text text-muted">Format: JPG, JPEG, PNG. Maksimal 2MB.</small>
                                    <?php if (!empty($activity['foto'])): ?>
                                        <div class="mt-2">
                                            <img src="<?= base_url($activity['foto']) ?>" alt="Current Photo" class="img-thumbnail" style="max-width: 150px;">
                                            <p class="text-muted mt-1">Foto saat ini</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="video">Video</label>
                                    <input type="file" class="form-control-file" id="video" name="video" accept="video/*">
                                    <small class="form-text text-muted">Format: MP4, AVI, MOV. Maksimal 10MB.</small>
                                    <?php if (!empty($activity['video'])): ?>
                                        <div class="mt-2">
                                            <video width="150" height="100" controls>
                                                <source src="<?= base_url($activity['video']) ?>" type="video/mp4">
                                                Browser Anda tidak mendukung video.
                                            </video>
                                            <p class="text-muted mt-1">Video saat ini</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Aktivitas
                            </button>
                            <a href="<?= base_url('admin/activities') ?>" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>