<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 mb-0">Tambah Aktivitas</h1>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('admin/activities') ?>">Aktivitas</a></li>
                <li class="breadcrumb-item active">Tambah Baru</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-body">
                <form action="<?= base_url('admin/activities/create') ?>" method="post" enctype="multipart/form-data">
                    <?= csrf_field() ?>
                    
                    <div class="mb-3">
                        <label for="nama_aktivitas" class="form-label">Nama Aktivitas</label>
                        <input type="text" class="form-control <?= $validation->hasError('nama_aktivitas') ? 'is-invalid' : '' ?>" 
                               id="nama_aktivitas" name="nama_aktivitas" value="<?= old('nama_aktivitas') ?>" required>
                        <?php if ($validation->hasError('nama_aktivitas')): ?>
                            <div class="invalid-feedback">
                                <?= $validation->getError('nama_aktivitas') ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="tanggal" class="form-label">Tanggal</label>
                            <input type="date" class="form-control <?= $validation->hasError('tanggal') ? 'is-invalid' : '' ?>" 
                                   id="tanggal" name="tanggal" value="<?= old('tanggal') ?>" required>
                            <?php if ($validation->hasError('tanggal')): ?>
                                <div class="invalid-feedback">
                                    <?= $validation->getError('tanggal') ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="jam" class="form-label">Jam</label>
                            <input type="time" class="form-control <?= $validation->hasError('jam') ? 'is-invalid' : '' ?>" 
                                   id="jam" name="jam" value="<?= old('jam') ?>" required>
                            <?php if ($validation->hasError('jam')): ?>
                                <div class="invalid-feedback">
                                    <?= $validation->getError('jam') ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="deskripsi" class="form-label">Deskripsi</label>
                        <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5"><?= old('deskripsi') ?></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="foto" class="form-label">Foto</label>
                            <input type="file" class="form-control" id="foto" name="foto" accept="image/*">
                            <div class="form-text">Format: JPG, PNG, GIF (Maksimal 2MB)</div>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="video" class="form-label">Video</label>
                            <input type="file" class="form-control" id="video" name="video" accept="video/*">
                            <div class="form-text">Format: MP4, AVI, MOV (Maksimal 10MB)</div>
                        </div>
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>
                            Simpan
                        </button>
                        <a href="<?= base_url('admin/activities') ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>
                            Kembali
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    Panduan
                </h5>
            </div>
            <div class="card-body">
                <h6>Tips Mengisi Aktivitas:</h6>
                <ul class="list-unstyled">
                    <li>• Gunakan nama aktivitas yang jelas dan deskriptif</li>
                    <li>• Isi tanggal dan jam sesuai dengan waktu aktivitas</li>
                    <li>• Deskripsi sebaiknya detail dan informatif</li>
                    <li>• Foto dan video opsional untuk dokumentasi</li>
                </ul>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>