<?= $this->extend('layout/post_layout') ?>

<?= $this->section('content') ?>

<div class="container">
    <!-- Search and Filter Section -->
    <div class="search-filter-card">
        <div class="card-body">
            <form method="get" action="<?= base_url('activities') ?>">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">
                            <i class="fas fa-search me-2"></i>
                            Cari Aktivitas
                        </label>
                        <input type="text" name="search" class="form-control" 
                               placeholder="Cari nama aktivitas atau deskripsi..." 
                               value="<?= esc($search) ?>">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">
                            <i class="fas fa-calendar me-2"></i>
                            Filter Tanggal
                        </label>
                        <input type="date" name="filter_tanggal" class="form-control" 
                               value="<?= esc($filter_tanggal) ?>">
                    </div>
                    <div class="col-md-2 mb-3">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search"></i>
                            </button>
                            <a href="<?= base_url('activities') ?>" class="btn btn-secondary">
                                <i class="fas fa-refresh"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Sorting Options -->
    <div class="sorting-card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center">
                <small class="text-muted fw-bold">
                    <i class="fas fa-sort me-2"></i>
                    Urutkan berdasarkan:
                </small>
                <div class="d-flex gap-2">
                    <a href="<?= base_url('activities?sort_by=nama_aktivitas&sort_order=' . ($sort_by == 'nama_aktivitas' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_tanggal=' . urlencode($filter_tanggal)) ?>" 
                       class="btn btn-sm btn-outline-primary">
                        Nama Aktivitas <?= $sort_by == 'nama_aktivitas' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
                    </a>
                    <a href="<?= base_url('activities?sort_by=tanggal&sort_order=' . ($sort_by == 'tanggal' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_tanggal=' . urlencode($filter_tanggal)) ?>" 
                       class="btn btn-sm btn-outline-primary">
                        Tanggal <?= $sort_by == 'tanggal' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
                    </a>
                    <a href="<?= base_url('activities?sort_by=jam&sort_order=' . ($sort_by == 'jam' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_tanggal=' . urlencode($filter_tanggal)) ?>" 
                       class="btn btn-sm btn-outline-primary">
                        Jam <?= $sort_by == 'jam' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Activities Cards -->
    <?php if (empty($activities)): ?>
        <div class="empty-state">
            <i class="fas fa-calendar-alt"></i>
            <h4>Belum ada data aktivitas</h4>
            <p>Data aktivitas harian akan ditampilkan di sini ketika sudah tersedia</p>
        </div>
    <?php else: ?>
        <div class="activities-grid">
            <?php foreach($activities as $activity): ?>
                <div class="activity-card-wrapper">
                    <div class="card activity-card">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-start">
                                <div style="flex: 1;">
                                    <h5 class="activity-title"><?= esc($activity['nama_aktivitas']) ?></h5>
                                    <div class="activity-date">
                                        <i class="fas fa-calendar-alt me-2"></i>
                                        <?= date('d F Y', strtotime($activity['tanggal'])) ?>
                                        <span class="ms-2">
                                            <i class="fas fa-clock me-1"></i>
                                            <?= date('H:i', strtotime($activity['jam'])) ?>
                                        </span>
                                    </div>
                                </div>
                                <span class="badge badge-primary">
                                    <?= date('M', strtotime($activity['tanggal'])) ?>
                                </span>
                            </div>
                        </div>
                        
                        <div class="card-body" style="flex: 1;">
                            <?php if (!empty($activity['deskripsi'])): ?>
                                <p class="activity-description"><?= esc($activity['deskripsi']) ?></p>
                            <?php endif; ?>
                            
                            <?php if (!empty($activity['foto']) || !empty($activity['video'])): ?>
                                <div class="activity-media">
                                    <?php if (!empty($activity['foto'])): ?>
                                        <img src="<?= base_url($activity['foto']) ?>" 
                                             class="img-fluid rounded" 
                                             alt="<?= esc($activity['nama_aktivitas']) ?>"
                                             style="max-height: 200px; width: 100%; object-fit: cover;">
                                    <?php elseif (!empty($activity['video'])): ?>
                                        <video controls class="w-100 rounded" style="max-height: 200px;">
                                            <source src="<?= base_url($activity['video']) ?>" type="video/mp4">
                                            Browser Anda tidak mendukung video.
                                        </video>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="card-footer">
                            <div class="d-flex justify-content-between align-items-center">
                                <small class="text-muted">
                                    <i class="fas fa-clock me-1"></i>
                                    <?= date('d/m/Y H:i', strtotime($activity['created_at'])) ?>
                                </small>
                                <?php if (!empty($activity['foto']) || !empty($activity['video'])): ?>
                                    <span class="badge badge-success">
                                        <i class="fas fa-<?= !empty($activity['foto']) ? 'image' : 'video' ?> me-1"></i>
                                        Media
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <!-- Pagination -->
        <?php if ($pager->getPageCount() > 1): ?>
            <div class="pagination-wrapper">
                <?= $pager->links() ?>
            </div>
        <?php endif; ?>
    <?php endif; ?>
</div>

<?= $this->endSection() ?>