<?php

namespace App\Models;

use CodeIgniter\Model;

class ProfileModel extends Model
{
    protected $table            = 'profile';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'name',
        'title',
        'description',
        'photo',
        'email',
        'phone',
        'address',
        'social_media',
        'is_active'
    ];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // Validation
    protected $validationRules = [
        'name'        => 'required|min_length[3]|max_length[255]',
        'title'       => 'max_length[255]',
        'email'       => 'valid_email|max_length[255]',
        'phone'       => 'max_length[50]',
        'photo'       => 'max_length[255]'
    ];

    protected $validationMessages = [
        'name' => [
            'required'    => 'Nama harus diisi',
            'min_length'  => 'Nama minimal 3 karakter',
            'max_length'  => 'Nama maksimal 255 karakter'
        ],
        'email' => [
            'valid_email' => 'Format email tidak valid'
        ]
    ];

    protected $skipValidation = false;

    /**
     * Get active profile
     */
    public function getActiveProfile()
    {
        return $this->where('is_active', 1)->first();
    }

    /**
     * Update profile with photo handling
     */
    public function updateProfile($id, $data)
    {
        // Handle social media JSON
        if (isset($data['social_media']) && is_array($data['social_media'])) {
            $data['social_media'] = json_encode($data['social_media']);
        }
        
        return $this->update($id, $data);
    }

    /**
     * Get profile with decoded social media
     */
    public function getProfileWithSocialMedia($id = null)
    {
        $profile = $id ? $this->find($id) : $this->getActiveProfile();
        
        if ($profile && isset($profile['social_media'])) {
            $profile['social_media'] = json_decode($profile['social_media'], true);
        }
        
        return $profile;
    }
}