<?php

namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class AdminAuth implements FilterInterface
{
    /**
     * Do whatever processing this filter needs to do.
     * By default it should not return anything during
     * normal execution. However, when an abnormal state
     * is found, it should return an instance of
     * CodeIgniter\HTTP\Response. If it does, script
     * execution will end and that Response will be
     * sent back to the client, allowing for error pages,
     * redirects, etc.
     *
     * @param RequestInterface $request
     * @param array|null       $arguments
     *
     * @return mixed
     */
    public function before(RequestInterface $request, $arguments = null)
    {
        $session = \Config\Services::session();
        
        // Check if admin is logged in
        if (!$session->get('admin_logged_in')) {
            // Check remember me cookie
            if (isset($_COOKIE['admin_remember'])) {
                return redirect()->to('/admin/auth/check-remember');
            }
            
            return redirect()->to('/admin/login')->with('error', 'Silakan login terlebih dahulu');
        }

        // Check if admin is active (optional additional security)
        $adminModel = new \App\Models\AdminModel();
        $admin = $adminModel->getAdmin($session->get('admin_id'));
        
        if (!$admin) {
            $session->destroy();
            return redirect()->to('/admin/login')->with('error', 'Akun tidak aktif atau tidak ditemukan');
        }
    }

    /**
     * Allows After filters to inspect and modify the response
     * object as needed. This method does not allow any way
     * to stop execution of other after filters, short of
     * throwing an Exception or Error.
     *
     * @param RequestInterface  $request
     * @param ResponseInterface $response
     * @param array|null        $arguments
     *
     * @return mixed
     */
    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // Do something here
    }
}